/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.deployment;

import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.msgsimple.load.MessageBundleLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceDirectoryBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.IndexView;

class RestOpenapiProcessor {
    private static final String FEATURE = "camel-rest-openapi";
    private static final List<String> GROUP_IDS_TO_INDEX = List.of("com.github.java-json-tools", "com.atlassian.oai", "io.swagger.core.v3");

    RestOpenapiProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexDependencies(CurateOutcomeBuildItem curateOutcome, BuildProducer<IndexDependencyBuildItem> indexedDependency) {
        curateOutcome.getApplicationModel().getDependencies().stream().filter(dependency -> GROUP_IDS_TO_INDEX.contains(dependency.getGroupId())).map(dependency -> new IndexDependencyBuildItem(dependency.getGroupId(), dependency.getArtifactId())).forEach(arg_0 -> indexedDependency.produce(arg_0));
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        ArrayList reflectiveClassNames = new ArrayList();
        IndexView index = combinedIndex.getIndex();
        index.getAllKnownImplementors(MessageBundleLoader.class).stream().map(classInfo -> classInfo.name().toString()).forEach(reflectiveClassNames::add);
        index.getAllKnownImplementors(KeywordValidator.class).stream().map(classInfo -> classInfo.name().toString()).forEach(reflectiveClassNames::add);
        index.getAllKnownSubclasses(Schema.class).stream().map(classInfo -> classInfo.name().toString()).forEach(reflectiveClassNames::add);
        index.getClassesInPackage("io.swagger.v3.core.jackson.mixin").stream().map(classInfo -> classInfo.name().toString()).forEach(reflectiveClassNames::add);
        return ReflectiveClassBuildItem.builder((String[])reflectiveClassNames.toArray(new String[0])).build();
    }

    @BuildStep
    void nativeImageResources(BuildProducer<NativeImageResourceDirectoryBuildItem> nativeImageResourceDirectory, BuildProducer<NativeImageResourceBuildItem> nativeImageResource) {
        nativeImageResourceDirectory.produce((BuildItem)new NativeImageResourceDirectoryBuildItem("swagger/validation"));
        nativeImageResourceDirectory.produce((BuildItem)new NativeImageResourceDirectoryBuildItem("draftv3"));
        nativeImageResourceDirectory.produce((BuildItem)new NativeImageResourceDirectoryBuildItem("draftv4"));
        nativeImageResourceDirectory.produce((BuildItem)new NativeImageResourceDirectoryBuildItem("com/github/fge/jsonschema/validator"));
        nativeImageResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"com/github/fge/uritemplate/messages.properties"}));
    }
}

