/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.rest.openapi.deployment;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenArgument;
import io.swagger.codegen.v3.DefaultGenerator;
import io.swagger.codegen.v3.config.CodegenConfigurator;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class CamelQuarkusSwaggerCodegenProvider
implements CodeGenProvider {
    private static final Logger LOG = Logger.getLogger(CamelQuarkusSwaggerCodegenProvider.class);

    public String providerId() {
        return "camel-quarkus-rest-openapi";
    }

    public String[] inputExtensions() {
        return new String[]{"json"};
    }

    public String inputDirectory() {
        return "openapi";
    }

    public boolean trigger(CodeGenContext context) throws CodeGenException {
        Config config = context.config();
        if (!((Boolean)config.getValue("quarkus.camel.openapi.codegen.enabled", Boolean.class)).booleanValue()) {
            LOG.info((Object)("Skipping " + String.valueOf(this.getClass()) + " invocation on user's request"));
            return false;
        }
        try {
            ArrayList jsonFiles = new ArrayList();
            if (Files.isDirectory(context.inputDir(), new LinkOption[0])) {
                try (Stream<Path> protoFilesPaths = Files.walk(context.inputDir(), new FileVisitOption[0]);){
                    protoFilesPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(s -> s.toString().endsWith("json")).map(Path::normalize).map(Path::toAbsolutePath).map(Path::toString).forEach(jsonFiles::add);
                }
            }
            String packageName = (String)config.getValue("quarkus.camel.openapi.codegen.model-package", String.class);
            String models = config.getOptionalValue("quarkus.camel.openapi.codegen.models", String.class).orElse("");
            boolean useBeanValidation = (Boolean)config.getValue("quarkus.camel.openapi.codegen.use-bean-validation", Boolean.class);
            boolean notNullJackson = (Boolean)config.getValue("quarkus.camel.openapi.codegen.not-null-jackson", Boolean.class);
            for (String jsonFile : jsonFiles) {
                CodegenConfigurator configurator = new CodegenConfigurator();
                configurator.setLang("quarkus");
                configurator.setLibrary("quarkus3");
                configurator.setModelPackage(packageName);
                configurator.setInputSpecURL(jsonFile);
                configurator.setOutputDir(context.outDir().toAbsolutePath().toString());
                System.setProperty("models", models);
                configurator.getCodegenArguments().add(new CodegenArgument().option("--api-docs").type("boolean").value("false"));
                configurator.getCodegenArguments().add(new CodegenArgument().option("--model-docs").type("boolean").value("false"));
                if (useBeanValidation) {
                    configurator.getAdditionalProperties().put("useBeanValidation", "true");
                }
                if (notNullJackson) {
                    configurator.getAdditionalProperties().put("notNullJacksonAnnotation", "true");
                }
                ClientOptInput input = configurator.toClientOptInput();
                new DefaultGenerator().opts(input).generate();
            }
            return true;
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to generate java files from json file in " + String.valueOf(context.inputDir().toAbsolutePath()), (Throwable)e);
        }
    }
}

