/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.reactive.streams.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Overridable;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.runtime.RuntimeValue;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsServiceFactory;
import org.apache.camel.quarkus.component.reactive.streams.ReactiveStreamsProducers;
import org.apache.camel.quarkus.component.reactive.streams.ReactiveStreamsRecorder;
import org.apache.camel.quarkus.component.reactive.streams.deployment.ReactiveStreamsServiceFactoryBuildItem;
import org.apache.camel.quarkus.core.Flags;
import org.apache.camel.quarkus.core.deployment.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelContextBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelServiceFilter;
import org.apache.camel.quarkus.core.deployment.CamelServiceFilterBuildItem;

class ReactiveStreamsProcessor {
    private static final String SCHEME = "reactive-streams";
    private static final String FEATURE = "camel-reactive-streams";

    ReactiveStreamsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    CamelServiceFilterBuildItem serviceFilter() {
        return new CamelServiceFilterBuildItem(CamelServiceFilter.forComponent((String)SCHEME));
    }

    @BuildStep(onlyIf={Flags.MainEnabled.class})
    void beans(BuildProducer<AdditionalBeanBuildItem> beanProducer) {
        beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ReactiveStreamsProducers.class));
    }

    @Overridable
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    public ReactiveStreamsServiceFactoryBuildItem defaultReactiveStreamsServiceFactory(ReactiveStreamsRecorder recorder) {
        return new ReactiveStreamsServiceFactoryBuildItem((RuntimeValue<CamelReactiveStreamsServiceFactory>)recorder.createDefaultReactiveStreamsServiceFactory());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem reactiveStreamsComponent(ReactiveStreamsRecorder recorder, ReactiveStreamsServiceFactoryBuildItem reactiveStreamsServiceFactory) {
        return new CamelBeanBuildItem(SCHEME, "org.apache.camel.component.reactive.streams.ReactiveStreamsComponent", recorder.createReactiveStreamsComponent(reactiveStreamsServiceFactory.getValue()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void publishCamelReactiveStreamsService(BeanContainerBuildItem beanContainer, ReactiveStreamsRecorder recorder, CamelContextBuildItem camelContext, ReactiveStreamsServiceFactoryBuildItem reactiveStreamsServiceFactory) {
        recorder.publishCamelReactiveStreamsService(beanContainer.getValue(), camelContext.getCamelContext(), reactiveStreamsServiceFactory.getValue());
    }
}

