/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pubnub.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.IndexView;

class PubnubProcessor {
    private static final String FEATURE = "camel-pubnub";

    PubnubProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencies() {
        return new IndexDependencyBuildItem("com.pubnub", "pubnub-gson");
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] reflectiveClasses = (String[])index.getKnownClasses().stream().map(classInfo -> classInfo.name().toString()).filter(name -> name.startsWith("com.pubnub.api.models")).toArray(String[]::new);
        return new ReflectiveClassBuildItem(false, true, reflectiveClasses);
    }

    @BuildStep
    void registerProxyInterfaces(BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        index.getKnownClasses().stream().map(classInfo -> classInfo.name().toString()).filter(name -> name.startsWith("com.pubnub.api.services")).map(xva$0 -> new NativeImageProxyDefinitionBuildItem(new String[]{xva$0})).forEach(arg_0 -> proxyDefinitions.produce(arg_0));
    }
}

