/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.protobuf.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.protobuf.it.model.AddressBookProtos;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class ProtobufTest {
    static final int id = 2345;
    static final String name = "Joe";
    static final String json = "{\"name\": \"Joe\",\"id\": 2345}";
    static final AddressBookProtos.Person person = AddressBookProtos.Person.newBuilder().setId(2345).setName("Joe").build();
    static final byte[] protobuf = person.toByteArray();

    ProtobufTest() {
    }

    @Test
    void marshal() {
        byte[] actual = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("application/json").queryParam("name", new Object[]{name}).queryParam("id", new Object[]{2345}).get("/protobuf/marshal", new Object[0])).then()).statusCode(200)).extract().body().asByteArray();
        Assertions.assertArrayEquals((byte[])protobuf, (byte[])actual);
    }

    @Test
    void unmarshal() {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("application/octet-stream").body(protobuf).post("/protobuf/unmarshal", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)json), new Matcher[0]);
    }
}

