/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.protobuf.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.protobuf.it.model.AddressBookProtos;

@Path(value="/protobuf")
@ApplicationScoped
public class ProtobufResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/marshal")
    @GET
    @Produces(value={"application/octet-stream"})
    public byte[] xstreamXmlMarshal(@QueryParam(value="id") int id, @QueryParam(value="name") String name) {
        AddressBookProtos.Person person = AddressBookProtos.Person.newBuilder().setId(id).setName(name).build();
        return (byte[])this.producerTemplate.requestBody("direct:protobuf-marshal", (Object)person, byte[].class);
    }

    @Path(value="/unmarshal")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public String unmarshal(byte[] body) {
        AddressBookProtos.Person person = (AddressBookProtos.Person)this.producerTemplate.requestBody("direct:protobuf-unmarshal", (Object)body, AddressBookProtos.Person.class);
        return "{\"name\": \"" + person.getName() + "\",\"id\": " + person.getId() + "}";
    }
}

