/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.protobuf.deployment;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.GeneratedMessageV3;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class ProtobufProcessor {
    private static final Logger LOG = Logger.getLogger(ProtobufProcessor.class);
    private static final String FEATURE = "camel-protobuf";
    private static final DotName[] MESSAGE_CLASS_DOT_NAMES = new DotName[]{DotName.createSimple((String)GeneratedMessageV3.class.getName()), DotName.createSimple((String)GeneratedMessage.class.getName())};

    ProtobufProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView index = combinedIndexBuildItem.getIndex();
        for (DotName dotName : MESSAGE_CLASS_DOT_NAMES) {
            index.getAllKnownSubclasses(dotName).stream().map(classInfo -> ReflectiveClassBuildItem.builder((String[])new String[]{classInfo.name().toString()}).methods().build()).forEach(arg_0 -> reflectiveClasses.produce(arg_0));
        }
    }
}

