/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.platform.http.runtime;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.Method;
import org.apache.camel.quarkus.core.UploadAttacher;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.jboss.logging.Logger;

public class QuarkusPlatformHttpConsumer
extends DefaultConsumer {
    private static final Logger LOG = Logger.getLogger(QuarkusPlatformHttpConsumer.class);
    private final Router router;
    private final List<Handler<RoutingContext>> handlers;
    private Route route;
    private final String fileNameExtWhitelist;
    private final UploadAttacher uploadAttacher;
    private final Pattern PATH_PARAMETER_PATTERN = Pattern.compile("\\{([^/}]+)\\}");

    public QuarkusPlatformHttpConsumer(PlatformHttpEndpoint endpoint, Processor processor, Router router, List<Handler<RoutingContext>> handlers, UploadAttacher uploadAttacher) {
        super((Endpoint)endpoint, processor);
        this.router = router;
        this.handlers = handlers;
        String list = endpoint.getFileNameExtWhitelist();
        this.fileNameExtWhitelist = list == null ? list : list.toLowerCase(Locale.US);
        this.uploadAttacher = uploadAttacher;
    }

    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        PlatformHttpEndpoint endpoint = this.getEndpoint();
        String path = endpoint.getPath();
        String vertxPathParamPath = this.PATH_PARAMETER_PATTERN.matcher(path).replaceAll(":$1");
        Route newRoute = this.router.route(vertxPathParamPath);
        Set methods = Method.parseList((String)endpoint.getHttpMethodRestrict());
        if (!methods.equals(Method.getAll())) {
            methods.stream().forEach(m -> newRoute.method(HttpMethod.valueOf((String)m.name())));
        }
        if (endpoint.getConsumes() != null) {
            newRoute.consumes(endpoint.getConsumes());
        }
        if (endpoint.getProduces() != null) {
            newRoute.produces(endpoint.getProduces());
        }
        this.handlers.forEach(arg_0 -> ((Route)newRoute).handler(arg_0));
        newRoute.handler(ctx -> {
            Exchange exchg = null;
            try {
                Exchange exchange = exchg = this.toExchange((RoutingContext)ctx);
                this.createUoW(exchange);
                this.getAsyncProcessor().process(exchange, doneSync -> QuarkusPlatformHttpConsumer.writeResponse(ctx, exchange, this.getEndpoint().getHeaderFilterStrategy()));
            }
            catch (Exception e) {
                ctx.fail((Throwable)e);
                this.getExceptionHandler().handleException("Failed handling platform-http endpoint " + path, exchg, (Throwable)e);
            }
            finally {
                if (exchg != null) {
                    this.doneUoW(exchg);
                }
            }
        });
        this.route = newRoute;
    }

    protected void doStop() throws Exception {
        if (this.route != null) {
            this.route.remove();
            this.route = null;
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.route != null) {
            this.route.disable();
        }
        super.doSuspend();
    }

    protected void doResume() throws Exception {
        if (this.route != null) {
            this.route.enable();
        }
        super.doResume();
    }

    static Object toHttpResponse(HttpServerResponse response, Message message, HeaderFilterStrategy headerFilterStrategy) {
        Integer length;
        Exchange exchange = message.getExchange();
        int code = QuarkusPlatformHttpConsumer.determineResponseCode(exchange, message.getBody());
        response.setStatusCode(code);
        TypeConverter tc = exchange.getContext().getTypeConverter();
        if (headerFilterStrategy != null) {
            for (Map.Entry entry : message.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Iterator it = ObjectHelper.createIterator(value, null);
                String firstValue = null;
                ArrayList<String> values = null;
                while (it.hasNext()) {
                    String headerValue = (String)tc.convertTo(String.class, it.next());
                    if (headerValue == null || headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
                    if (firstValue == null) {
                        firstValue = headerValue;
                        continue;
                    }
                    if (values == null) {
                        values = new ArrayList<String>();
                        values.add(firstValue);
                    }
                    values.add(headerValue);
                }
                if (values != null) {
                    response.putHeader(key, values);
                    continue;
                }
                if (firstValue == null) continue;
                response.putHeader(key, firstValue);
            }
        }
        Object body = message.getBody();
        Exception exception = exchange.getException();
        if (exception != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            body = ByteBuffer.wrap(sw.toString().getBytes(StandardCharsets.UTF_8));
            message.setHeader("Content-Type", (Object)"text/plain; charset=utf-8");
            ExchangeHelper.setFailureHandled((Exchange)exchange);
        }
        if ((length = QuarkusPlatformHttpConsumer.determineContentLength(exchange, body)) != null) {
            response.putHeader("Content-Length", String.valueOf(length));
        } else {
            response.setChunked(true);
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            response.putHeader("Content-Type", contentType);
        }
        return body;
    }

    static Integer determineContentLength(Exchange camelExchange, Object body) {
        if (body instanceof byte[]) {
            return ((byte[])body).length;
        }
        if (body instanceof ByteBuffer) {
            return ((ByteBuffer)body).remaining();
        }
        return null;
    }

    static int determineResponseCode(Exchange camelExchange, Object body) {
        int codeToUse;
        boolean failed = camelExchange.isFailed();
        int defaultCode = failed ? 500 : 200;
        Message message = camelExchange.getMessage();
        Integer currentCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
        int n = codeToUse = currentCode == null ? defaultCode : currentCode;
        if (codeToUse != 500 && (body == null || body instanceof String && ((String)body).trim().isEmpty())) {
            codeToUse = currentCode == null ? 204 : currentCode;
        }
        return codeToUse;
    }

    static void writeResponse(RoutingContext ctx, Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy) {
        Object body = QuarkusPlatformHttpConsumer.toHttpResponse(ctx.response(), camelExchange.getMessage(), headerFilterStrategy);
        HttpServerResponse response = ctx.response();
        if (body == null) {
            LOG.tracef("No payload to send as reply for exchange: %s", (Object)camelExchange);
            response.end();
        } else if (body instanceof String) {
            response.end((String)body);
        } else if (body instanceof InputStream) {
            byte[] bytes = new byte[4096];
            try (InputStream in = (InputStream)body;){
                int len;
                while ((len = in.read(bytes)) >= 0) {
                    Buffer b = Buffer.buffer((int)len);
                    b.appendBytes(bytes, 0, len);
                    response.write(b);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            response.end();
        } else {
            TypeConverter tc = camelExchange.getContext().getTypeConverter();
            try {
                ByteBuffer bb = (ByteBuffer)tc.mandatoryConvertTo(ByteBuffer.class, body);
                Buffer b = Buffer.buffer((int)bb.capacity());
                b.setBytes(0, bb);
                response.end(b);
            }
            catch (NoTypeConversionAvailableException | TypeConversionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    Exchange toExchange(RoutingContext ctx) {
        Exchange exchange = this.getEndpoint().createExchange();
        Message in = this.toCamelMessage(ctx, exchange);
        String charset = ctx.parsedHeaders().contentType().parameter("charset");
        if (charset != null) {
            exchange.setProperty("CamelCharsetName", (Object)charset);
            in.setHeader("CamelHttpCharacterEncoding", (Object)charset);
        }
        exchange.setIn(in);
        return exchange;
    }

    static void populateCamelHeaders(RoutingContext ctx, Map<String, Object> headersMap, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        HttpServerRequest request = ctx.request();
        headersMap.put("CamelHttpPath", request.path());
        if (headerFilterStrategy != null) {
            MultiMap requestHeaders = request.headers();
            String authz = requestHeaders.get("authorization");
            if (authz != null && authz.trim().startsWith("Basic") && !headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
                QuarkusPlatformHttpConsumer.appendHeader(headersMap, "CamelAuthentication", "Basic");
            }
            for (String name : requestHeaders.names()) {
                for (String value : requestHeaders.getAll(name)) {
                    if (headerFilterStrategy.applyFilterToExternalHeaders(name.toString(), (Object)value, exchange)) continue;
                    QuarkusPlatformHttpConsumer.appendHeader(headersMap, name.toString(), value);
                }
            }
            MultiMap pathParameters = ctx.queryParams();
            if (!pathParameters.isEmpty()) {
                for (String name : pathParameters.names()) {
                    for (String value : pathParameters.getAll(name)) {
                        if (headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                        QuarkusPlatformHttpConsumer.appendHeader(headersMap, name, value);
                    }
                }
            }
        }
        for (Map.Entry en : ctx.pathParams().entrySet()) {
            QuarkusPlatformHttpConsumer.appendHeader(headersMap, (String)en.getKey(), en.getValue());
        }
        headersMap.put("CamelHttpMethod", request.method().toString());
        headersMap.put("CamelHttpUrl", request.absoluteURI());
        headersMap.put("CamelHttpUri", request.uri());
        headersMap.put("CamelHttpQuery", request.query());
        headersMap.put("CamelHttpRawQuery", request.query());
    }

    Message toCamelMessage(RoutingContext ctx, Exchange exchange) {
        DefaultMessage result = new DefaultMessage(exchange);
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        QuarkusPlatformHttpConsumer.populateCamelHeaders(ctx, result.getHeaders(), exchange, headerFilterStrategy);
        String mimeType = ctx.parsedHeaders().contentType().value();
        boolean isMultipartFormData = "multipart/form-data".equals(mimeType);
        if ("application/x-www-form-urlencoded".equals(mimeType) || isMultipartFormData) {
            MultiMap formData = ctx.request().formAttributes();
            HashMap<String, Object> body = new HashMap<String, Object>();
            for (String key : formData.names()) {
                for (String value : formData.getAll(key)) {
                    if (headerFilterStrategy == null || headerFilterStrategy.applyFilterToExternalHeaders(key, (Object)value, exchange)) continue;
                    QuarkusPlatformHttpConsumer.appendHeader(result.getHeaders(), key, value);
                    QuarkusPlatformHttpConsumer.appendHeader(body, key, value);
                }
            }
            result.setBody(body);
            if (isMultipartFormData) {
                this.populateAttachments(ctx.fileUploads(), (Message)result);
            }
        } else {
            Method m = Method.valueOf((String)ctx.request().method().name());
            if (m.canHaveBody()) {
                Buffer body = ctx.getBody();
                result.setBody((Object)body.getBytes());
            } else {
                result.setBody(null);
            }
        }
        return result;
    }

    static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    void populateAttachments(Set<FileUpload> uploads, Message message) {
        for (FileUpload upload : uploads) {
            String ext;
            String name = upload.name();
            String fileName = upload.fileName();
            LOG.tracef("HTTP attachment %s = %s", (Object)name, (Object)fileName);
            boolean accepted = true;
            if (this.fileNameExtWhitelist != null && (ext = FileUtil.onlyExt((String)fileName)) != null) {
                ext = ext.toLowerCase(Locale.US);
                if (!this.fileNameExtWhitelist.equals("*") && !this.fileNameExtWhitelist.contains(ext)) {
                    accepted = false;
                }
            }
            if (accepted) {
                File localFile = new File(upload.uploadedFileName());
                this.uploadAttacher.attachUpload(localFile, fileName, message);
                continue;
            }
            LOG.debugf("Cannot add file as attachment: %s because the file is not accepted according to fileNameExtWhitelist: %s", (Object)fileName, (Object)this.fileNameExtWhitelist);
        }
    }
}

