/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.platform.http.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import io.vertx.ext.web.Router;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpEngine;
import org.apache.camel.quarkus.component.platform.http.deployment.PlatformHttpEngineBuildItem;
import org.apache.camel.quarkus.component.platform.http.runtime.PlatformHttpRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilter;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceFilterBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelTypeConverterLoaderBuildItem;

class PlatformHttpProcessor {
    private static final String FEATURE = "camel-platform-http";

    PlatformHttpProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    CamelServiceFilterBuildItem serviceFilter() {
        return new CamelServiceFilterBuildItem(CamelServiceFilter.forComponent((String)"platform-http"));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    PlatformHttpEngineBuildItem platformHttpEngine(PlatformHttpRecorder recorder) {
        return new PlatformHttpEngineBuildItem((RuntimeValue<PlatformHttpEngine>)recorder.createEngine());
    }

    @BuildStep
    CamelRuntimeBeanBuildItem platformHttpEngineBean(PlatformHttpEngineBuildItem engine) {
        return new CamelRuntimeBeanBuildItem("platform-http-engine", VertxPlatformHttpEngine.class.getName(), engine.getInstance());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    CamelRuntimeBeanBuildItem platformHttpRouterBean(VertxBuildItem vertx, VertxWebRouterBuildItem router, BodyHandlerBuildItem bodyHandler, PlatformHttpRecorder recorder) {
        return new CamelRuntimeBeanBuildItem("platform-http-router", Router.class.getName(), recorder.createVertxPlatformHttpRouter(vertx.getVertx(), router.getHttpRouter(), bodyHandler.getHandler()));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    CamelRuntimeBeanBuildItem platformHttpComponentBean(PlatformHttpRecorder recorder, PlatformHttpEngineBuildItem engine) {
        return new CamelRuntimeBeanBuildItem("platform-http", PlatformHttpComponent.class.getName(), recorder.createComponent(engine.getInstance()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelTypeConverterLoaderBuildItem vertxByteBufferConverterLoader(PlatformHttpRecorder recorder) {
        return new CamelTypeConverterLoaderBuildItem(recorder.createVertxByteBufferConverterLoader());
    }
}

