/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.platform.http.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import java.util.Collections;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.quarkus.component.platform.http.deployment.PlatformHttpEngineBuildItem;
import org.apache.camel.quarkus.component.platform.http.runtime.PlatformHttpRecorder;
import org.apache.camel.quarkus.component.platform.http.runtime.QuarkusPlatformHttpEngine;
import org.apache.camel.quarkus.core.deployment.CamelRuntimeBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.CamelServiceFilter;
import org.apache.camel.quarkus.core.deployment.CamelServiceFilterBuildItem;
import org.apache.camel.quarkus.core.deployment.UploadAttacherBuildItem;

class PlatformHttpProcessor {
    private static final String FEATURE = "camel-platform-http";

    PlatformHttpProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    CamelServiceFilterBuildItem serviceFilter() {
        return new CamelServiceFilterBuildItem(CamelServiceFilter.forComponent((String)"platform-http"));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    PlatformHttpEngineBuildItem platformHttpEngine(PlatformHttpRecorder recorder, VertxWebRouterBuildItem router, BodyHandlerBuildItem bodyHandler, UploadAttacherBuildItem uploadAttacher) {
        return new PlatformHttpEngineBuildItem((RuntimeValue<PlatformHttpEngine>)recorder.createEngine(router.getRouter(), Collections.singletonList(bodyHandler.getHandler()), uploadAttacher.getInstance()));
    }

    @BuildStep
    CamelRuntimeBeanBuildItem platformHttpEngineBean(PlatformHttpEngineBuildItem engine) {
        return new CamelRuntimeBeanBuildItem("platform-http-engine", QuarkusPlatformHttpEngine.class.getName(), engine.getInstance());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    CamelRuntimeBeanBuildItem platformHttpComponentBean(PlatformHttpRecorder recorder, PlatformHttpEngineBuildItem engine) {
        return new CamelRuntimeBeanBuildItem("platform-http", PlatformHttpComponent.class.getName(), recorder.createComponent(engine.getInstance()));
    }
}

