/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.pgevent.deployment;

import com.impossibl.postgres.jdbc.PGBuffersStruct;
import com.impossibl.postgres.system.procs.ProcProvider;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.sql.Driver;
import java.util.Set;
import java.util.stream.Stream;

class PgeventProcessor {
    private static final String PGEVENT_SERVICE_BASE = "META-INF/services/";
    private static final String FEATURE = "camel-pgevent";

    PgeventProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ReflectiveClassBuildItem registerReflectiveClasses() {
        return ReflectiveClassBuildItem.builder((String[])new String[]{"io.netty.channel.nio.NioEventLoopGroup"}).fields().build();
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        runtimeInitializedClass.produce((BuildItem)new RuntimeInitializedClassBuildItem(PGBuffersStruct.class.getName()));
    }

    @BuildStep
    void registerNativeImageResources(BuildProducer<ServiceProviderBuildItem> services) {
        Stream.of(ProcProvider.class.getName(), Driver.class.getName()).forEach(service -> {
            try {
                Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)(PGEVENT_SERVICE_BASE + service));
                services.produce((BuildItem)new ServiceProviderBuildItem(service, implementations.toArray(new String[0])));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver, SslNativeConfigBuildItem sslNativeConfigBuildItem) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("postgresql", "com.impossibl.postgres.jdbc.PGDriver", "com.impossibl.postgres.jdbc.xa.PGXADataSource"));
    }
}

