/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.paho.mqtt5.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ResourceBundle;
import org.eclipse.paho.mqttv5.client.internal.ResourceBundleCatalog;
import org.eclipse.paho.mqttv5.client.internal.SSLNetworkModuleFactory;
import org.eclipse.paho.mqttv5.client.internal.TCPNetworkModuleFactory;
import org.eclipse.paho.mqttv5.client.logging.JSR47Logger;
import org.eclipse.paho.mqttv5.client.spi.NetworkModuleFactory;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketNetworkModuleFactory;
import org.eclipse.paho.mqttv5.client.websocket.WebSocketSecureNetworkModuleFactory;

class PahoMqtt5Processor {
    private static final String FEATURE = "camel-paho-mqtt5";

    PahoMqtt5Processor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerReflectiveClasses(BuildProducer<ReflectiveClassBuildItem> p) {
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{JSR47Logger.class}).build());
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ResourceBundleCatalog.class}).build());
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ResourceBundle.class}).build());
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FileLock.class}).build());
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{FileChannel.class}).methods().build());
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{RandomAccessFile.class}).methods().build());
        p.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"sun.nio.ch.FileLockImpl"}).methods().build());
    }

    @BuildStep
    ServiceProviderBuildItem registerServiceProviders() {
        return new ServiceProviderBuildItem(NetworkModuleFactory.class.getName(), new String[]{TCPNetworkModuleFactory.class.getName(), SSLNetworkModuleFactory.class.getName(), WebSocketNetworkModuleFactory.class.getName(), WebSocketSecureNetworkModuleFactory.class.getName()});
    }

    @BuildStep
    void registerResourceBundle(BuildProducer<NativeImageResourceBundleBuildItem> p) {
        p.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.eclipse.paho.mqttv5.client.internal.nls.logcat"));
        p.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.eclipse.paho.mqttv5.common.nls.messages"));
    }
}

