/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openstack.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import org.apache.camel.quarkus.component.openstack.deployment.BuildTimeDefaultAPIProvider;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.openstack4j.connectors.okhttp.HttpExecutorServiceImpl;
import org.openstack4j.core.transport.HttpExecutorService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.openstack.identity.v3.domain.KeystoneAuth;

class OpenstackProcessor {
    private static final Logger LOG = Logger.getLogger(OpenstackProcessor.class);
    private static final String FEATURE = "camel-openstack";

    OpenstackProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    RuntimeInitializedClassBuildItem runtimeInitOpenstack4jUntrustedSSL() {
        return new RuntimeInitializedClassBuildItem("org.openstack4j.core.transport.UntrustedSSL");
    }

    @BuildStep
    void registerOkhttpServiceProvider(BuildProducer<ServiceProviderBuildItem> services) {
        services.produce((BuildItem)new ServiceProviderBuildItem(HttpExecutorService.class.getName(), new String[]{HttpExecutorServiceImpl.class.getName()}));
    }

    @BuildStep
    void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        index.getAllKnownImplementors(DotName.createSimple((String)ModelEntity.class.getName())).stream().filter(CamelSupport::isConcrete).forEach(ci -> {
            String className = ci.asClass().name().toString();
            LOG.debugf("Registered openstack4j model class %s as reflective", (Object)className);
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods(true).fields(true).build());
        });
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KeystoneAuth.AuthIdentity.class}).methods(true).fields(true).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KeystoneAuth.AuthIdentity.AuthPassword.class}).methods(true).fields(true).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KeystoneAuth.AuthIdentity.AuthToken.class}).methods(true).fields(true).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KeystoneAuth.AuthScope.class}).methods(true).fields(true).build());
        BuildTimeDefaultAPIProvider prov = new BuildTimeDefaultAPIProvider();
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])prov.getReflectiveClasses()).methods(false).fields(false).build());
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.github.openstack4j.core", "openstack4j-core"));
    }
}

