/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapi.java.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.quarkus.component.openapi.java.deployment.CamelRestOASFilter;
import org.apache.camel.quarkus.component.openapi.java.deployment.OpenApiJavaBuildTimeConfig;
import org.apache.camel.quarkus.core.deployment.spi.CamelRoutesBuilderClassBuildItem;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpenApiJavaProcessor {
    private static final String FEATURE = "camel-openapi-java";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiJavaProcessor.class);
    private static final DotName SCHEMA = DotName.createSimple((String)Schema.class.getName());

    OpenApiJavaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.swagger.core.v3", "swagger-models"));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.swagger", "swagger-models"));
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, CombinedIndexBuildItem combinedIndex) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{SCHEMA.toString()}).methods().fields().build());
        IndexView index = combinedIndex.getIndex();
        index.getAllKnownSubclasses(SCHEMA).stream().map(ClassInfo::toString).forEach(name -> reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{name}).methods().build()));
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Discriminator.class}).build());
    }

    @BuildStep(onlyIf={ExposeOpenApiEnabled.class})
    void exposeOpenAPI(List<CamelRoutesBuilderClassBuildItem> routesBuilderClasses, BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPI, Capabilities capabilities) throws Exception {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            RoutesConfigurer configurer = new RoutesConfigurer();
            ArrayList<RouteBuilder> routes = new ArrayList<RouteBuilder>();
            configurer.setRoutesBuilders(routes);
            configurer.setRoutesCollector((RoutesCollector)new DefaultRoutesCollector());
            configurer.setRoutesIncludePattern((String)CamelSupport.getOptionalConfigValue((String)"camel.main.routes-include-pattern", String.class, null));
            configurer.setRoutesExcludePattern((String)CamelSupport.getOptionalConfigValue((String)"camel.main.routes-exclude-pattern", String.class, null));
            DefaultCamelContext ctx = new DefaultCamelContext();
            if (!routesBuilderClasses.isEmpty()) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (!(loader instanceof QuarkusClassLoader)) {
                    throw new IllegalStateException(QuarkusClassLoader.class.getSimpleName() + " expected as the context class loader");
                }
                for (CamelRoutesBuilderClassBuildItem routesBuilderClass : routesBuilderClasses) {
                    String className = routesBuilderClass.getDotName().toString();
                    Class<?> cl = loader.loadClass(className);
                    if (!RouteBuilder.class.isAssignableFrom(cl)) continue;
                    try {
                        RouteBuilder rb = (RouteBuilder)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        routes.add(rb);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException("Could not instantiate " + className, e);
                    }
                }
            }
            try {
                configurer.configureRoutes((CamelContext)ctx);
            }
            catch (Exception e) {
                LOGGER.warn("config routes failed with " + e);
            }
            openAPI.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)new CamelRestOASFilter((CamelContext)ctx)));
        }
    }

    public static final class ExposeOpenApiEnabled
    implements BooleanSupplier {
        OpenApiJavaBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

