/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.openapi.java.deployment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.definition.DefinitionReader;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestDefinitionsResolver;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.openapi.RestOpenApiReader;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.apache.camel.quarkus.component.openapi.java.deployment.OpenApiJavaProcessor;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.util.FileUtil;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CamelRestOASFilter
implements OASFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiJavaProcessor.class);
    private final CamelContext context;
    private final RestOpenApiReader reader = new RestOpenApiReader();
    private final RestDefinitionsResolver resolver = new DefaultRestDefinitionsResolver();
    private static final BiConsumer<Object, Consumer<String>> consumeProperty = (a, b) -> Optional.ofNullable(a).map(String.class::cast).ifPresent((Consumer<String>)b);

    public CamelRestOASFilter(CamelContext context) {
        this.context = context;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        try {
            List rests = this.resolver.getRestDefinitions(this.context, null);
            if (rests == null || rests.isEmpty()) {
                LOGGER.warn("Unable to find Camel REST definitions to expose on the Quarkus OpenAPI endpoint.");
                return;
            }
            BeanConfig bc = new BeanConfig();
            Info info = new Info();
            RestConfiguration rc = this.context.getRestConfiguration();
            CamelRestOASFilter.initOpenApi(bc, info, rc, Optional.ofNullable(rc.getApiProperties()).orElseGet(HashMap::new));
            io.swagger.v3.oas.models.OpenAPI openApi = this.reader.read(this.context, rests, bc, null, this.context.getClassResolver());
            if (!rc.isApiVendorExtension()) {
                OpenApiHelper.clearVendorExtensions((io.swagger.v3.oas.models.OpenAPI)openApi);
            }
            ObjectMapper mapper = new ObjectMapper(new JsonFactory());
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String jsonContent = RestOpenApiSupport.getJsonFromOpenAPIAsString((io.swagger.v3.oas.models.OpenAPI)openApi, (BeanConfig)bc);
            JsonNode node = mapper.readTree(jsonContent);
            OpenAPIImpl oai = new OpenAPIImpl();
            DefinitionReader.processDefinition((OpenAPI)oai, (JsonNode)node);
            MergeUtil.merge((OpenAPI)openAPI, (OpenAPI)oai);
        }
        catch (Exception e) {
            LOGGER.warn("Error generating OpenAPI from Camel Rest DSL due to: {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void initOpenApi(BeanConfig bc, Info info, RestConfiguration rc, Map<String, Object> config) {
        Config c = ConfigProvider.getConfig();
        String host = c.getOptionalValue("quarkus.http.host", String.class).orElse("localhost");
        String port = c.getOptionalValue("quarkus.http.port", String.class).orElse("8080");
        bc.setHost(host + ":" + port);
        bc.setBasePath("/");
        String contextPath = Optional.ofNullable(rc.getContextPath()).orElseGet(() -> c.getOptionalValue("camel.rest.context-path", String.class).orElse(null));
        rc.setContextPath(contextPath);
        c.getOptionalValue("quarkus.http.root-path", String.class).ifPresent(s -> rc.setContextPath((String)(contextPath == null ? s : s + "/" + FileUtil.stripLeadingSeparator((String)contextPath))));
        consumeProperty.accept(config.get("openapi.version"), arg_0 -> ((BeanConfig)bc).setVersion(arg_0));
        consumeProperty.accept(config.get("base.path"), arg_0 -> ((BeanConfig)bc).setBasePath(arg_0));
        consumeProperty.accept(config.get("host"), arg_0 -> ((BeanConfig)bc).setHost(arg_0));
        consumeProperty.accept(config.get("api.version"), arg_0 -> ((Info)info).setVersion(arg_0));
        consumeProperty.accept(config.get("api.description"), arg_0 -> ((Info)info).setDescription(arg_0));
        consumeProperty.accept(config.get("api.termsOfService"), arg_0 -> ((Info)info).setTermsOfService(arg_0));
        consumeProperty.accept(config.get("api.license.name"), arg_0 -> ((BeanConfig)bc).setLicense(arg_0));
        consumeProperty.accept(config.get("api.license.url"), arg_0 -> ((BeanConfig)bc).setLicenseUrl(arg_0));
        consumeProperty.accept(config.get("api.title"), s -> {
            bc.setTitle(s);
            info.setTitle(s);
        });
        Optional.of(config.getOrDefault("schemes", config.getOrDefault("schemas", "http"))).map(String.class::cast).map(v -> v.split(",")).ifPresent(arg_0 -> ((BeanConfig)bc).setSchemes(arg_0));
        Optional.ofNullable(config.get("api.contact.name")).map(String.class::cast).map(name -> new Contact().name(name).email((String)config.get("api.contact.email")).url((String)config.get("api.contact.url"))).ifPresent(arg_0 -> ((Info)info).setContact(arg_0));
    }
}

