/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mybatis.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path(value="/mybatis")
@ApplicationScoped
public class MybatisResource {
    private static final Logger LOG = Logger.getLogger(MybatisResource.class);
    private static final String COMPONENT_MYBATIS = "mybatis";
    private static final String COMPONENT_MYBATIS_BEAN = "mybatis-bean";
    @Inject
    CamelContext context;

    @Path(value="/load/component/mybatis")
    @GET
    @Produces(value={"text/plain"})
    public Response loadComponentMybatis() throws Exception {
        if (this.context.getComponent(COMPONENT_MYBATIS) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)COMPONENT_MYBATIS);
        return Response.status((int)500, (String)"mybatis could not be loaded from the Camel context").build();
    }

    @Path(value="/load/component/mybatis-bean")
    @GET
    @Produces(value={"text/plain"})
    public Response loadComponentMybatisBean() throws Exception {
        if (this.context.getComponent(COMPONENT_MYBATIS_BEAN) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", (Object)COMPONENT_MYBATIS_BEAN);
        return Response.status((int)500, (String)"mybatis-bean could not be loaded from the Camel context").build();
    }
}

