/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mybatis.deployment;

import io.quarkiverse.mybatis.deployment.SqlSessionFactoryBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.List;
import org.apache.camel.component.mybatis.MyBatisBeanComponent;
import org.apache.camel.component.mybatis.MyBatisComponent;
import org.apache.camel.quarkus.component.mybatis.runtime.CamelMyBatisRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.jboss.logging.Logger;

class MybatisProcessor {
    private static final Logger LOG = Logger.getLogger(MybatisProcessor.class);
    private static final String FEATURE = "camel-mybatis";

    MybatisProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem mybatisComponent(List<SqlSessionFactoryBuildItem> sqlSessionFactoryBuildItems, CamelMyBatisRecorder recorder) throws Throwable {
        return new CamelBeanBuildItem("mybatis", MyBatisComponent.class.getName(), recorder.createMyBatisComponent(this.findXmlSqlSessionFactory(sqlSessionFactoryBuildItems).getSqlSessionFactory()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem mybatisBeanComponent(List<SqlSessionFactoryBuildItem> sqlSessionFactoryBuildItems, CamelMyBatisRecorder recorder) throws Throwable {
        return new CamelBeanBuildItem("mybatis-bean", MyBatisBeanComponent.class.getName(), recorder.createMyBatisBeanComponent(this.findXmlSqlSessionFactory(sqlSessionFactoryBuildItems).getSqlSessionFactory()));
    }

    private SqlSessionFactoryBuildItem findXmlSqlSessionFactory(List<SqlSessionFactoryBuildItem> sqlSessionFactoryBuildItems) throws Throwable {
        return sqlSessionFactoryBuildItems.stream().filter(s -> s.isFromXmlConfig()).findFirst().orElseThrow(() -> new ConfigurationException("No MyBatis XML Config"));
    }
}

