/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.microprofile.metrics.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.metrics.MetricRegistries;
import org.apache.camel.CamelContext;
import org.apache.camel.component.microprofile.metrics.event.notifier.context.MicroProfileMetricsCamelContextEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.exchange.MicroProfileMetricsExchangeEventNotifier;
import org.apache.camel.component.microprofile.metrics.event.notifier.route.MicroProfileMetricsRouteEventNotifier;
import org.apache.camel.component.microprofile.metrics.message.history.MicroProfileMetricsMessageHistoryFactory;
import org.apache.camel.component.microprofile.metrics.route.policy.MicroProfileMetricsRoutePolicyFactory;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainListenerSupport;
import org.apache.camel.quarkus.component.microprofile.metrics.runtime.CamelMicroProfileMetricsConfig;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.logging.Logger;

@Recorder
public class CamelMicroProfileMetricsRecorder {
    public RuntimeValue<MetricRegistry> createApplicationRegistry() {
        return new RuntimeValue((Object)MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION));
    }

    public RuntimeValue<MainListener> createContextConfigurerListener(CamelMicroProfileMetricsConfig config) {
        return new RuntimeValue((Object)new MicroProfileMetricsContextConfigurerListener(config));
    }

    public void configureCamelContext(CamelMicroProfileMetricsConfig config, RuntimeValue<CamelContext> camelContextRuntimeValue) {
        CamelContext camelContext = (CamelContext)camelContextRuntimeValue.getValue();
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        if (config.enableRoutePolicy) {
            camelContext.addRoutePolicyFactory((RoutePolicyFactory)new MicroProfileMetricsRoutePolicyFactory());
        }
        if (config.enableExchangeEventNotifier) {
            managementStrategy.addEventNotifier((EventNotifier)new MicroProfileMetricsExchangeEventNotifier());
        }
        if (config.enableRouteEventNotifier) {
            managementStrategy.addEventNotifier((EventNotifier)new MicroProfileMetricsRouteEventNotifier());
        }
        if (config.enableCamelContextEventNotifier) {
            managementStrategy.addEventNotifier((EventNotifier)new MicroProfileMetricsCamelContextEventNotifier());
        }
    }

    private static class MicroProfileMetricsContextConfigurerListener
    extends MainListenerSupport {
        private static final Logger LOGGER = Logger.getLogger(MicroProfileMetricsContextConfigurerListener.class);
        private final CamelMicroProfileMetricsConfig config;

        public MicroProfileMetricsContextConfigurerListener(CamelMicroProfileMetricsConfig config) {
            this.config = config;
        }

        public void configure(CamelContext camelContext) {
            if (!this.config.enableMessageHistory) {
                return;
            }
            if (!camelContext.isMessageHistory().booleanValue()) {
                LOGGER.warn((Object)"MessageHistory is not use and will be enabled as required by MicroProfile Metrics for MessageHistory");
                camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            camelContext.setMessageHistoryFactory((MessageHistoryFactory)new MicroProfileMetricsMessageHistoryFactory());
        }
    }
}

