/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mapstruct.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.camel.component.mapstruct.MapstructComponent;
import org.apache.camel.quarkus.component.mapstruct.ConversionMethodInfo;
import org.apache.camel.quarkus.component.mapstruct.MapStructRecorder;
import org.apache.camel.quarkus.component.mapstruct.deployment.ConversionMethodInfoRuntimeValuesBuildItem;
import org.apache.camel.quarkus.component.mapstruct.deployment.MapStructMapperPackagesBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelTypeConverterRegistryBuildItem;
import org.apache.camel.support.SimpleTypeConverter;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.StringHelper;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.mapstruct.Mapper;

class MapStructProcessor {
    private static final String FEATURE = "camel-mapstruct";

    MapStructProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    MapStructMapperPackagesBuildItem getMapperPackages(CombinedIndexBuildItem combinedIndex) {
        HashSet<String> mapperPackages = new HashSet<String>();
        Optional mapperPackageName = ConfigProvider.getConfig().getOptionalValue("camel.component.mapstruct.mapper-package-name", String.class);
        if (mapperPackageName.isPresent()) {
            String packages = StringUtils.deleteWhitespace((String)((String)mapperPackageName.get()));
            mapperPackages.addAll(Arrays.asList(packages.split(",")));
        } else {
            combinedIndex.getIndex().getAnnotations(Mapper.class).stream().map(AnnotationInstance::target).map(AnnotationTarget::asClass).map(ClassInfo::name).map(DotName::packagePrefix).forEach(mapperPackages::add);
        }
        return new MapStructMapperPackagesBuildItem(mapperPackages);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    CamelBeanBuildItem mapStructComponentBean(MapStructMapperPackagesBuildItem mapperPackages, ConversionMethodInfoRuntimeValuesBuildItem conversionMethodInfos, MapStructRecorder recorder) {
        return new CamelBeanBuildItem("mapstruct", MapstructComponent.class.getName(), recorder.createMapStructComponent(mapperPackages.getMapperPackages(), conversionMethodInfos.getConversionMethodInfoRuntimeValues()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void generateMapStructTypeConverters(BuildProducer<GeneratedBeanBuildItem> generatedBean, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<UnremovableBeanBuildItem> unremovableBean, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ConversionMethodInfoRuntimeValuesBuildItem> conversionMethodInfos, CombinedIndexBuildItem combinedIndex, MapStructMapperPackagesBuildItem mapperPackages, MapStructRecorder recorder) {
        Set<String> packages = mapperPackages.getMapperPackages();
        AtomicInteger methodCount = new AtomicInteger();
        HashMap conversionMethods = new HashMap();
        IndexView index = combinedIndex.getIndex();
        index.getAnnotations(Mapper.class).stream().map(AnnotationInstance::target).map(AnnotationTarget::asClass).filter(classInfo -> packages.contains(classInfo.name().packagePrefix())).filter(classInfo -> classInfo.isInterface() || Modifier.isAbstract(classInfo.flags())).flatMap(classInfo -> Stream.concat(index.getAllKnownImplementors(classInfo.name()).stream(), index.getAllKnownSubclasses(classInfo.name()).stream())).forEach(classInfo -> {
            boolean mapperBeanExists;
            AtomicReference<RuntimeValue> mapperRuntimeValue = new AtomicReference<RuntimeValue>();
            String mapperClassName = classInfo.name().toString();
            String mapperDefinitionClassName = this.getMapperDefinitionClassName((ClassInfo)classInfo);
            if (ObjectHelper.isEmpty((String)mapperDefinitionClassName)) {
                return;
            }
            ClassInfo mapperDefinitionClassInfo = index.getClassByName(mapperDefinitionClassName);
            Optional<FieldInfo> mapperInstanceField = mapperDefinitionClassInfo.fields().stream().filter(fieldInfo -> Modifier.isStatic(fieldInfo.flags())).filter(fieldInfo -> fieldInfo.type().name().toString().equals(mapperDefinitionClassName)).findFirst();
            boolean bl = mapperBeanExists = classInfo.hasDeclaredAnnotation(ApplicationScoped.class) || classInfo.hasDeclaredAnnotation(Named.class);
            if (mapperInstanceField.isEmpty()) {
                if (mapperBeanExists) {
                    unremovableBean.produce((BuildItem)new UnremovableBeanBuildItem(beanInfo -> beanInfo.hasType(classInfo.name())));
                } else {
                    mapperRuntimeValue.set(recorder.createMapper(mapperClassName));
                }
            }
            ReflectionHelper.doWithMethods(this.resolveClass(mapperDefinitionClassName), method -> {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (method.getParameterCount() != 1) {
                    return;
                }
                Class<?> fromType = parameterTypes[0];
                Class<?> toType = method.getReturnType();
                if (toType.isPrimitive()) {
                    return;
                }
                String conversionMethodClassName = String.format("%s.%s%dConversionMethod", classInfo.name().packagePrefixName().toString(), StringHelper.capitalize((String)method.getName()), methodCount.incrementAndGet());
                GeneratedBeanGizmoAdaptor output = mapperBeanExists ? new GeneratedBeanGizmoAdaptor(generatedBean) : new GeneratedClassGizmoAdaptor(generatedClass, true);
                try (ClassCreator classCreator = ClassCreator.builder().className(conversionMethodClassName).classOutput((ClassOutput)output).setFinal(true).interfaces(new Class[]{SimpleTypeConverter.ConversionMethod.class}).superClass(Object.class.getName()).build();){
                    MethodCreator initMethod;
                    if (mapperBeanExists) {
                        classCreator.addAnnotation(Singleton.class);
                        unremovableBean.produce((BuildItem)new UnremovableBeanBuildItem(beanInfo -> beanInfo.hasType(DotName.createSimple((String)conversionMethodClassName))));
                    }
                    FieldCreator mapperField = (FieldCreator)classCreator.getFieldCreator("mapper", mapperClassName).setModifiers(18);
                    if (mapperInstanceField.isPresent() || mapperBeanExists) {
                        initMethod = classCreator.getMethodCreator("<init>", Void.TYPE, new Class[0]);
                        try {
                            initMethod.setModifiers(1);
                            if (mapperBeanExists) {
                                initMethod.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), initMethod.getThis(), new ResultHandle[0]);
                            } else {
                                FieldInfo fieldInfo = (FieldInfo)mapperInstanceField.get();
                                initMethod.invokeSpecialMethod(MethodDescriptor.ofConstructor((String)conversionMethodClassName, (String[])new String[]{mapperClassName}), initMethod.getThis(), new ResultHandle[]{initMethod.readStaticField(FieldDescriptor.of((String)mapperClassName, (String)fieldInfo.name(), (String)fieldInfo.type().toString()))});
                            }
                            initMethod.returnNull();
                        }
                        finally {
                            if (initMethod != null) {
                                initMethod.close();
                            }
                        }
                    }
                    initMethod = classCreator.getMethodCreator("<init>", Void.TYPE, new Object[]{mapperClassName});
                    try {
                        initMethod.setModifiers(1);
                        if (mapperBeanExists) {
                            initMethod.addAnnotation(Inject.class);
                        }
                        initMethod.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), initMethod.getThis(), new ResultHandle[0]);
                        initMethod.writeInstanceField(mapperField.getFieldDescriptor(), initMethod.getThis(), initMethod.getMethodParam(0));
                        initMethod.returnNull();
                    }
                    finally {
                        if (initMethod != null) {
                            initMethod.close();
                        }
                    }
                    try (MethodCreator doConvertMethod = classCreator.getMethodCreator("doConvert", Object.class, new Class[]{Class.class, Exchange.class, Object.class});){
                        doConvertMethod.setModifiers(1);
                        MethodDescriptor mapperMethod = MethodDescriptor.ofMethod((String)mapperClassName, (String)method.getName(), (String)toType.getName(), (String[])new String[]{fromType.getName()});
                        ResultHandle mapper = doConvertMethod.readInstanceField(mapperField.getFieldDescriptor(), doConvertMethod.getThis());
                        ResultHandle mapperResult = doConvertMethod.invokeVirtualMethod(mapperMethod, mapper, new ResultHandle[]{doConvertMethod.getMethodParam(2)});
                        doConvertMethod.returnValue(mapperResult);
                    }
                }
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{toType}).build());
                String key = String.format("%s:%s", fromType.getName(), toType.getName());
                conversionMethods.computeIfAbsent(key, conversionMethodsKey -> recorder.createConversionMethodInfo(fromType, toType, mapperBeanExists, (RuntimeValue)mapperRuntimeValue.get(), conversionMethodClassName));
            });
        });
        conversionMethodInfos.produce((BuildItem)new ConversionMethodInfoRuntimeValuesBuildItem(new HashSet<RuntimeValue<ConversionMethodInfo>>(conversionMethods.values())));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void registerTypeConverters(BeanContainerBuildItem beanContainer, CamelTypeConverterRegistryBuildItem typeConverterRegistry, ConversionMethodInfoRuntimeValuesBuildItem conversionMethodInfos, MapStructRecorder recorder) {
        recorder.registerMapStructTypeConverters(typeConverterRegistry.getRegistry(), conversionMethodInfos.getConversionMethodInfoRuntimeValues(), beanContainer.getValue());
    }

    @BuildStep
    void registerMapperServiceProviders(BuildProducer<ServiceProviderBuildItem> serviceProvider, CombinedIndexBuildItem combinedIndex, MapStructMapperPackagesBuildItem mapperPackages) {
        Set<String> packages = mapperPackages.getMapperPackages();
        combinedIndex.getIndex().getAnnotations(Mapper.class).stream().filter(annotationInstance -> packages.contains(annotationInstance.target().asClass().name().packagePrefix())).forEach(annotation -> {
            AnnotationValue value = annotation.value("implementationName");
            if (value != null) {
                DotName name = annotation.target().asClass().name();
                AnnotationValue implementationPackage = annotation.value("implementationPackage");
                String packageName = implementationPackage != null ? implementationPackage.asString() : name.packagePrefix();
                serviceProvider.produce((BuildItem)new ServiceProviderBuildItem(name.toString(), new String[]{packageName + "." + value.asString()}));
            }
        });
    }

    private String getMapperDefinitionClassName(ClassInfo mapStructMapperImpl) {
        List interfaces = mapStructMapperImpl.interfaceNames();
        if (interfaces.isEmpty()) {
            String superClassName = mapStructMapperImpl.superClassType().name().toString();
            if (!superClassName.equals(Object.class.getName())) {
                return superClassName;
            }
            return null;
        }
        return ((DotName)interfaces.get(0)).toString();
    }

    private Class<?> resolveClass(String className) {
        try {
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

