/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.quarkus.core.RegistryRoutesLoader;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;

public class CamelMainRoutesCollector
extends DefaultRoutesCollector {
    private final RegistryRoutesLoader registryRoutesLoader;

    public CamelMainRoutesCollector(RegistryRoutesLoader registryRoutesLoader) {
        this.registryRoutesLoader = registryRoutesLoader;
    }

    public RegistryRoutesLoader getRegistryRoutesLoader() {
        return this.registryRoutesLoader;
    }

    public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        return this.registryRoutesLoader.collectRoutesFromRegistry(camelContext, excludePattern, includePattern);
    }

    public List<RestsDefinition> collectXmlRestsFromDirectory(CamelContext camelContext, String directory) {
        String[] parts;
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        PackageScanResourceResolver resolver = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanResourceResolver();
        ArrayList<RestsDefinition> answer = new ArrayList<RestsDefinition>();
        StopWatch watch = new StopWatch();
        int count = 0;
        for (String part : parts = directory.split(",")) {
            this.log.debug("Loading additional Camel XML rests from: {}", (Object)part);
            try {
                Set set = resolver.findResources(part);
                for (InputStream is : set) {
                    this.log.debug("Found XML rest from location: {}", (Object)part);
                    RestsDefinition rests = (RestsDefinition)ecc.getXMLRoutesDefinitionLoader().loadRestsDefinition((CamelContext)ecc, is);
                    if (rests == null) continue;
                    answer.add(rests);
                    IOHelper.close((Closeable)is);
                    count += rests.getRests().size();
                }
            }
            catch (FileNotFoundException e) {
                this.log.debug("No XML rests found in {}. Skipping XML rests detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
            if (count > 0) {
                this.log.info("Loaded {} ({} millis) additional Camel XML rests from: {}", new Object[]{count, watch.taken(), directory});
                continue;
            }
            this.log.info("No additional Camel XML rests discovered from: {}", (Object)directory);
        }
        return answer;
    }
}

