/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.quarkus.core.RegistryRoutesLoader;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMainRoutesCollector
implements RoutesCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelMainRoutesCollector.class);
    private final RegistryRoutesLoader registryRoutesLoader;
    private final XMLRoutesDefinitionLoader xmlRoutesLoader;

    public CamelMainRoutesCollector(RegistryRoutesLoader registryRoutesLoader, XMLRoutesDefinitionLoader xmlRoutesLoader) {
        this.registryRoutesLoader = registryRoutesLoader;
        this.xmlRoutesLoader = xmlRoutesLoader;
    }

    public RegistryRoutesLoader getRegistryRoutesLoader() {
        return this.registryRoutesLoader;
    }

    public XMLRoutesDefinitionLoader getXmlRoutesLoader() {
        return this.xmlRoutesLoader;
    }

    public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
        return this.registryRoutesLoader.collectRoutesFromRegistry(camelContext, excludePattern, includePattern);
    }

    public List<RoutesDefinition> collectXmlRoutesFromDirectory(CamelContext camelContext, String directory) {
        ArrayList<RoutesDefinition> answer = new ArrayList<RoutesDefinition>();
        PackageScanResourceResolver resolver = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanResourceResolver();
        for (String part : directory.split(",")) {
            LOGGER.info("Loading additional Camel XML routes from: {}", (Object)part);
            try {
                for (InputStream is : resolver.findResources(part)) {
                    Object definition = this.xmlRoutesLoader.loadRoutesDefinition(camelContext, is);
                    if (!(definition instanceof RoutesDefinition)) continue;
                    answer.add((RoutesDefinition)definition);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("File {} can not be found. Skipping XML routes detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return answer;
    }

    public List<RouteTemplatesDefinition> collectXmlRouteTemplatesFromDirectory(CamelContext camelContext, String directory) throws Exception {
        ArrayList<RouteTemplatesDefinition> answer = new ArrayList<RouteTemplatesDefinition>();
        PackageScanResourceResolver resolver = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanResourceResolver();
        for (String part : directory.split(",")) {
            LOGGER.info("Loading additional Camel XML route templates from: {}", (Object)part);
            try {
                for (InputStream is : resolver.findResources(part)) {
                    Object definition = this.xmlRoutesLoader.loadRouteTemplatesDefinition(camelContext, is);
                    if (!(definition instanceof RestsDefinition)) continue;
                    answer.add((RouteTemplatesDefinition)definition);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("No XML route templates found in {}. Skipping XML route templates detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return answer;
    }

    public List<RestsDefinition> collectXmlRestsFromDirectory(CamelContext camelContext, String directory) {
        ArrayList<RestsDefinition> answer = new ArrayList<RestsDefinition>();
        PackageScanResourceResolver resolver = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getPackageScanResourceResolver();
        for (String part : directory.split(",")) {
            LOGGER.info("Loading additional Camel XML rests from: {}", (Object)part);
            try {
                for (InputStream is : resolver.findResources(part)) {
                    Object definition = this.xmlRoutesLoader.loadRestsDefinition(camelContext, is);
                    if (!(definition instanceof RestsDefinition)) continue;
                    answer.add((RestsDefinition)definition);
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("No XML rests found in {}. Skipping XML rests detection.", (Object)part);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
            }
        }
        return answer;
    }
}

