/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kubernetes.cluster.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import org.apache.camel.component.kubernetes.cluster.KubernetesClusterService;
import org.apache.camel.quarkus.component.kubernetes.cluster.KubernetesClusterServiceBuildTimeConfig;
import org.apache.camel.quarkus.component.kubernetes.cluster.KubernetesClusterServiceRecorder;
import org.apache.camel.quarkus.component.kubernetes.cluster.KubernetesClusterServiceRuntimeConfig;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;
import org.apache.camel.support.cluster.RebalancingCamelClusterService;

class KubernetesClusterServiceProcessor {
    KubernetesClusterServiceProcessor() {
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={KubernetesClusterServiceBuildTimeConfig.Enabled.class})
    @Consume(value=CamelContextBuildItem.class)
    CamelRuntimeBeanBuildItem setupKubernetesClusterService(KubernetesClusterServiceBuildTimeConfig buildTimeConfig, KubernetesClusterServiceRuntimeConfig runtimeConfig, KubernetesClusterServiceRecorder recorder) {
        if (buildTimeConfig.rebalancing) {
            RuntimeValue krcs = recorder.createKubernetesRebalancingClusterService(runtimeConfig);
            return new CamelRuntimeBeanBuildItem("kubernetesRebalancingClusterService", RebalancingCamelClusterService.class.getName(), krcs);
        }
        RuntimeValue kcs = recorder.createKubernetesClusterService(runtimeConfig);
        return new CamelRuntimeBeanBuildItem("kubernetesClusterService", KubernetesClusterService.class.getName(), kcs);
    }
}

