/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kubernetes.cluster.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import org.apache.camel.component.kubernetes.cluster.KubernetesClusterService;
import org.apache.camel.quarkus.component.kubernetes.cluster.KubernetesClusterServiceConfig;
import org.apache.camel.quarkus.component.kubernetes.cluster.KubernetesClusterServiceRecorder;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelContextBuildItem;
import org.apache.camel.support.cluster.RebalancingCamelClusterService;

class KubernetesClusterServiceProcessor {
    KubernetesClusterServiceProcessor() {
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={KubernetesClusterServiceConfig.Enabled.class})
    @Consume(value=CamelContextBuildItem.class)
    CamelBeanBuildItem setupKubernetesClusterService(KubernetesClusterServiceConfig config, KubernetesClusterServiceRecorder recorder) {
        if (config.rebalancing) {
            RuntimeValue krcs = recorder.createKubernetesRebalancingClusterService(config);
            return new CamelBeanBuildItem("kubernetesRebalancingClusterService", RebalancingCamelClusterService.class.getName(), krcs);
        }
        RuntimeValue kcs = recorder.createKubernetesClusterService(config);
        return new CamelBeanBuildItem("kubernetesClusterService", KubernetesClusterService.class.getName(), kcs);
    }
}

