/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.kotlin.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.kotlin.deployment.KotlinCompilationProvider;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.quarkus.core.deployment.main.CamelMainHelper;
import org.apache.camel.quarkus.dsl.kotlin.runtime.Configurer;
import org.apache.camel.quarkus.support.dsl.deployment.DslGeneratedClassBuildItem;
import org.apache.camel.quarkus.support.dsl.deployment.DslSupportProcessor;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KotlinDslProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(KotlinDslProcessor.class);
    private static final String PACKAGE_NAME = "org.apache.camel.quarkus.dsl.kotlin.generated";
    private static final String FILE_FORMAT = "package %s\n%s\nclass %s(builder: org.apache.camel.builder.endpoint.EndpointRouteBuilder) :\n  %s(builder) { \n  override fun configure() { \n    %s\n  }\n}";
    private static final String FEATURE = "camel-kotlin-dsl";

    KotlinDslProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void compileScriptsAOT(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<GeneratedResourceBuildItem> generatedResource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<DslGeneratedClassBuildItem> generatedKotlinClass, BuildSystemTargetBuildItem buildSystemTargetBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        LOG.debug("Loading .kts resources");
        Path projectDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        Path outputDirectory = buildSystemTargetBuildItem.getOutputDirectory();
        Path generatedSourceDir = outputDirectory.resolve("kotlin-dsl/generated-sources");
        Files.createDirectories(generatedSourceDir, new FileAttribute[0]);
        Path generatedSourceHomeDir = generatedSourceDir.resolve(PACKAGE_NAME.replace('.', File.separatorChar));
        Files.createDirectories(generatedSourceHomeDir, new FileAttribute[0]);
        HashMap nameToResource = new HashMap();
        HashSet filesToCompile = new HashSet();
        CamelMainHelper.forEachMatchingResource(resource -> {
            if (!resource.getLocation().endsWith(".kts")) {
                return;
            }
            String name = DslSupportProcessor.determineName((Resource)resource);
            try (InputStream is = resource.getInputStream();){
                String content = KotlinDslProcessor.toKotlinClass(name, IOHelper.loadText((InputStream)is));
                LOG.debug("Generated Kotlin source content:\n {}", (Object)content);
                Path sourceFile = generatedSourceHomeDir.resolve(String.format("%s.kt", name));
                Files.write(sourceFile, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                filesToCompile.add(sourceFile.toFile());
                nameToResource.put(String.format("%s.%s", PACKAGE_NAME, name), resource);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (filesToCompile.isEmpty()) {
            return;
        }
        Path classesDir = outputDirectory.resolve("kotlin-dsl/generated-classes");
        Files.createDirectories(classesDir, new FileAttribute[0]);
        CompilationProvider.Context context = new CompilationProvider.Context(FEATURE, curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().map(ResolvedDependency::getResolvedPaths).flatMap(PathCollection::stream).map(Path::toFile).filter(f -> f.getName().endsWith(".jar")).collect(Collectors.toSet()), Set.of(), projectDir.toFile(), generatedSourceDir.toFile(), classesDir.toFile(), StandardCharsets.UTF_8.name(), Map.of(), "17", "17", "17", List.of(), List.of());
        try (KotlinCompilationProvider compiler = new KotlinCompilationProvider();){
            compiler.compile(filesToCompile, context);
        }
        try (Stream<Path> classFiles = Files.walk(classesDir, new FileVisitOption[0]);){
            classFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                String fileName = p.getFileName().toString();
                String relativePath = classesDir.relativize((Path)p).toString();
                try {
                    if (fileName.endsWith(".class")) {
                        String className = relativePath.replace(File.separatorChar, '.').substring(0, relativePath.length() - ".class".length());
                        generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, className, Files.readAllBytes(p)));
                        if (nameToResource.containsKey(className)) {
                            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).build());
                            generatedKotlinClass.produce((BuildItem)new DslGeneratedClassBuildItem(className, ((Resource)nameToResource.get(className)).getLocation()));
                        }
                    } else {
                        generatedResource.produce((BuildItem)new GeneratedResourceBuildItem(relativePath.replace(File.separatorChar, '/'), Files.readAllBytes(p)));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read " + p);
                }
            });
        }
    }

    private static String toKotlinClass(String name, String contentResource) {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("import org.apache.camel.*");
        imports.add("import org.apache.camel.spi.*");
        DslSupportProcessor.ExtractImportResult extractImportResult = DslSupportProcessor.extractImports((String)contentResource);
        imports.addAll(extractImportResult.getImports());
        return String.format(FILE_FORMAT, PACKAGE_NAME, String.join((CharSequence)"\n", imports), name, Configurer.class.getName(), extractImportResult.getContent());
    }
}

