/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kafka.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.kafka.client.deployment.KafkaBuildTimeConfig;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.camel.quarkus.component.kafka.KafkaClientFactoryProducer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

class KafkaProcessor {
    private static final String FEATURE = "camel-kafka";
    private static final String CAMEL_KAFKA_BROKERS = "camel.component.kafka.brokers";
    private static final String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    private static final DotName[] KAFKA_CLIENTS_TYPES = new DotName[]{DotName.createSimple((String)"org.apache.kafka.clients.producer.Producer"), DotName.createSimple((String)"org.apache.kafka.clients.consumer.Consumer")};

    KafkaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void createKafkaClientFactoryProducerBean(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KafkaClientFactoryProducer.class));
        }
    }

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void configureKafkaComponentForDevServices(DevServicesLauncherConfigResultBuildItem devServiceResult, KafkaBuildTimeConfig kafkaBuildTimeConfig, BuildProducer<RunTimeConfigurationDefaultBuildItem> runTimeConfig) {
        String kafkaBootstrapServers;
        Config config = ConfigProvider.getConfig();
        Optional brokers = config.getOptionalValue(CAMEL_KAFKA_BROKERS, String.class);
        if (brokers.isEmpty() && kafkaBuildTimeConfig.devservices.enabled.orElse(true).booleanValue() && (kafkaBootstrapServers = (String)devServiceResult.getConfig().get(KAFKA_BOOTSTRAP_SERVERS)) != null) {
            runTimeConfig.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem(CAMEL_KAFKA_BROKERS, kafkaBootstrapServers));
        }
    }

    @BuildStep
    public void reflectiveClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndex.getIndex();
        Stream.of(KAFKA_CLIENTS_TYPES).map(arg_0 -> ((IndexView)index).getAllKnownImplementors(arg_0)).flatMap(Collection::stream).map(ClassInfo::toString).forEach(name -> reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{name}).fields().build()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.apache.kafka.clients.producer.internals.Sender"}).fields().build());
    }
}

