/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.kafka.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.kafka.client.deployment.DevServicesKafkaBrokerBuildItem;
import io.quarkus.kafka.client.deployment.KafkaBuildTimeConfig;
import java.util.Optional;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.quarkus.component.kafka.CamelKafkaRecorder;
import org.apache.camel.quarkus.component.kafka.KafkaClientFactoryProducer;
import org.apache.camel.quarkus.core.deployment.spi.CamelBeanBuildItem;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

class KafkaProcessor {
    private static final String FEATURE = "camel-kafka";

    KafkaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void createKafkaClientFactoryProducerBean(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBean) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KafkaClientFactoryProducer.class));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
    public void configureKafkaComponentForDevServices(DevServicesKafkaBrokerBuildItem kafkaBrokerBuildItem, KafkaBuildTimeConfig kafkaBuildTimeConfig, BuildProducer<CamelBeanBuildItem> camelBean, CamelKafkaRecorder recorder) {
        Config config = ConfigProvider.getConfig();
        Optional brokers = config.getOptionalValue("camel.component.kafka.brokers", String.class);
        if (brokers.isEmpty() && kafkaBuildTimeConfig.devservices.enabled.orElse(true).booleanValue()) {
            camelBean.produce((BuildItem)new CamelBeanBuildItem("kafka", KafkaComponent.class.getName(), recorder.createKafkaComponentForDevServices(kafkaBrokerBuildItem.getBootstrapServers())));
        }
    }
}

