/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.camel.quarkus.test.CallbackUtil;
import org.apache.camel.quarkus.test.CamelQuarkusTestSupport;

public class BeforeEachCallback
implements QuarkusTestBeforeEachCallback {
    public void beforeEach(QuarkusTestMethodContext context) {
        if (context.getTestInstance() instanceof CamelQuarkusTestSupport) {
            CamelQuarkusTestSupport testInstance = (CamelQuarkusTestSupport)((Object)context.getTestInstance());
            CallbackUtil.MockExtensionContext mockContext = new CallbackUtil.MockExtensionContext(CallbackUtil.getLifecycle(testInstance), this.getDisplayName(context.getTestMethod()));
            try {
                testInstance.internalBeforeEach(mockContext);
                testInstance.internalBeforeAll(mockContext);
                testInstance.setUp();
                testInstance.doBeforeEach(context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getDisplayName(Method method) {
        return String.format("%s(%s)", method.getName(), Arrays.stream(method.getParameterTypes()).map(c -> c.getSimpleName()).collect(Collectors.joining(", ")));
    }
}

