/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test;

import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.callback.QuarkusTestContext;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.quarkus.core.FastCamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelQuarkusTestSupport
extends CamelTestSupport
implements QuarkusTestProfile {
    private static final Logger LOG = LoggerFactory.getLogger(CamelQuarkusTestSupport.class);
    @Inject
    protected CamelContext context;
    Set<String> createdRoutes;

    protected void doAfterAll(QuarkusTestContext context) throws Exception {
    }

    protected void doAfterEach(QuarkusTestMethodContext context) throws Exception {
    }

    protected void doAfterConstruct() throws Exception {
    }

    protected void doBeforeEach(QuarkusTestMethodContext context) throws Exception {
    }

    protected CamelContext createCamelContext() throws Exception {
        return this.context;
    }

    protected void bindToRegistry(Registry registry) throws Exception {
        Assertions.assertEquals((Object)this.context, (Object)((CamelTestSupport)this).context, (String)"Different context found!");
        super.bindToRegistry(registry);
    }

    protected void postProcessTest() throws Exception {
        Assertions.assertEquals((Object)this.context, (Object)((CamelTestSupport)this).context, (String)"Different context found!");
        super.postProcessTest();
    }

    public CamelContext context() {
        Assertions.assertEquals((Object)this.context, (Object)((CamelTestSupport)this).context, (String)"Different context found!");
        return super.context();
    }

    protected final Registry createCamelRegistry() {
        throw new UnsupportedOperationException("won't be executed.");
    }

    public final void beforeAll(ExtensionContext context) {
    }

    public final void beforeEach(ExtensionContext context) throws Exception {
    }

    public final void afterAll(ExtensionContext context) {
    }

    public final void afterEach(ExtensionContext context) throws Exception {
    }

    public final void afterTestExecution(ExtensionContext context) throws Exception {
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected void stopCamelContext() throws Exception {
    }

    protected final void doQuarkusCheck() {
        if (this.isUseRouteBuilder() && !this.context.getRegistry().findByType(RouteBuilder.class).isEmpty()) {
            LOG.warn("Test with `true` in `isUserRouteBuilder' and `RouteBuilder` detected in the context registry. All tests will share this routeBuilder from the registry. This is usually not intended. If `@Produces` is used to create such a RouteBuilder, please refactor the code by overriding the method `createRouteBuilder()` instead.");
        }
    }

    void internalAfterAll(QuarkusTestContext context, ExtensionContext extensionContext) {
        try {
            if (this.isCreateCamelContextPerClass()) {
                super.afterAll(extensionContext);
            } else {
                this.doPostTearDown();
            }
            this.cleanupResources();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void internalBeforeAll(ExtensionContext context) {
        super.beforeAll(context);
    }

    void internalBeforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
    }

    protected void doPreSetup() throws Exception {
        if (this.isUseAdviceWith() || this.isUseDebugger()) {
            ((FastCamelContext)this.context).suspend();
        }
        if (this.isUseRouteBuilder()) {
            this.createdRoutes = this.context.getRoutes().stream().map(r -> r.getRouteId()).collect(Collectors.toSet());
        }
        super.doPreSetup();
    }

    protected void doPostSetup() throws Exception {
        if (this.isUseAdviceWith() || this.isUseDebugger()) {
            ((FastCamelContext)this.context).resume();
            if (this.isUseDebugger()) {
                ModelCamelContext mcc = (ModelCamelContext)this.context;
                List rdfs = mcc.getRouteDefinitions();
                mcc.addRouteDefinitions((Collection)rdfs);
            }
        }
        if (this.isUseRouteBuilder()) {
            Set allRoutes = this.context.getRoutes().stream().map(r -> r.getRouteId()).collect(Collectors.toSet());
            if (this.createdRoutes != null) {
                allRoutes.removeAll(this.createdRoutes);
            }
            this.createdRoutes = allRoutes;
        }
        super.doPostSetup();
    }

    protected final void doStopCamelContext(CamelContext context, Service camelContextService) {
    }

    protected final void startCamelContext() {
    }

    public boolean isUseAdviceWith() {
        return false;
    }

    protected void startRouteDefinitions() throws Exception {
        ModelCamelContext modelCamelContext = (ModelCamelContext)this.context;
        ArrayList definitions = new ArrayList(modelCamelContext.getRouteDefinitions());
        for (Route r : this.context.getRoutes()) {
            definitions.remove(r.getRoute());
        }
        modelCamelContext.startRouteDefinitions(definitions);
    }
}

