/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.json.validator.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.jboss.jandex.DotName;

class JsonValidatorProcessor {
    private static final String FEATURE = "camel-json-validator";
    private static final DotName VALIDATOR_INTERFACE = DotName.createSimple((String)"com.networknt.schema.JsonValidator");

    JsonValidatorProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    IndexDependencyBuildItem addNetworkNtJsonValidatorArtifactToIndex() {
        return new IndexDependencyBuildItem("com.networknt", "json-schema-validator");
    }

    @BuildStep
    void registerReflectiveClasses(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveProducer) {
        combinedIndex.getIndex().getAllKnownImplementors(VALIDATOR_INTERFACE).stream().forEach(c -> reflectiveProducer.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{c.name().toString()})));
    }
}

