/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.js.runtime;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.quarkus.dsl.js.runtime.JavaScriptDslHelper;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public final class JavaScriptDslProcessor
implements Processor {
    private final String argumentName;
    private final CharSequence source;

    public JavaScriptDslProcessor(CharSequence source) {
        this("exchange", source);
    }

    public JavaScriptDslProcessor(String argumentName, CharSequence source) {
        this.argumentName = argumentName;
        this.source = source;
    }

    public void process(Exchange exchange) {
        try (Context context = JavaScriptDslHelper.createBuilder().build();){
            Value bindings = context.getBindings("js");
            bindings.putMember(this.argumentName, (Object)exchange);
            context.eval("js", this.source);
        }
    }
}

