/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.js.runtime;

import java.util.function.BiFunction;
import org.apache.camel.quarkus.dsl.js.runtime.JavaScriptDslHelper;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public final class JavaScriptDslBiFunction<T, U, R>
implements BiFunction<T, U, R> {
    private final String firstArgumentName;
    private final String secondArgumentName;
    private final CharSequence source;

    public JavaScriptDslBiFunction(CharSequence source) {
        this("t", "u", source);
    }

    public JavaScriptDslBiFunction(String firstArgumentName, String secondArgumentName, CharSequence source) {
        this.firstArgumentName = firstArgumentName;
        this.secondArgumentName = secondArgumentName;
        this.source = source;
    }

    @Override
    public R apply(T t, U u) {
        try (Context context = JavaScriptDslHelper.createBuilder().build();){
            Value bindings = context.getBindings("js");
            bindings.putMember(this.firstArgumentName, t);
            bindings.putMember(this.secondArgumentName, u);
            Value value = context.eval("js", this.source);
            Object object = value == null ? null : value.as(Object.class);
            return (R)object;
        }
    }
}

