/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jira.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.IndexView;
import org.joda.time.DateTimeZone;

class JiraProcessor {
    private static final String FEATURE = "camel-jira";
    private static final String JIRA_MODEL_PACKAGE = "com.atlassian.jira.rest.client.api.domain";

    JiraProcessor() {
    }

    @BuildStep
    ExtensionSslNativeSupportBuildItem activateSslNativeSupport() {
        return new ExtensionSslNativeSupportBuildItem(FEATURE);
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageResourceBuildItem nativeImageResources() {
        ArrayList<String> timezones = new ArrayList<String>();
        for (String timezone : DateTimeZone.getAvailableIDs()) {
            String[] zoneParts = timezone.split("/");
            if (zoneParts.length != 2) continue;
            timezones.add(String.format("org/joda/time/tz/data/%s/%s", zoneParts[0], zoneParts[1]));
        }
        return new NativeImageResourceBuildItem(timezones);
    }

    @BuildStep
    ReflectiveClassBuildItem registerJiraClassesForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] modelClasses = (String[])index.getKnownClasses().stream().map(ci -> ci.name().toString()).filter(n -> n.startsWith(JIRA_MODEL_PACKAGE)).toArray(String[]::new);
        return ReflectiveClassBuildItem.builder((String[])modelClasses).methods(true).build();
    }

    @BuildStep
    IndexDependencyBuildItem registerDependencyForIndex() {
        return new IndexDependencyBuildItem("com.atlassian.jira", "jira-rest-java-client-api");
    }

    @BuildStep
    List<ReflectiveClassBuildItem> registerReflectiveClasses() {
        ArrayList<ReflectiveClassBuildItem> items = new ArrayList<ReflectiveClassBuildItem>();
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{"com.atlassian.jira.rest.client.api.StatusCategory"}).methods(true).build());
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{"org.codehaus.jettison.json.JSONArray"}).methods(true).build());
        items.add(ReflectiveClassBuildItem.builder((String[])new String[]{"org.codehaus.jettison.json.JSONObject"}).methods(true).build());
        return items;
    }
}

