/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jfr.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import org.apache.camel.quarkus.component.jfr.CamelJfrRecorder;
import org.apache.camel.quarkus.component.jfr.RuntimeCamelJfrConfig;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceDestination;
import org.apache.camel.quarkus.core.deployment.spi.CamelServicePatternBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.RuntimeCamelContextCustomizerBuildItem;

class JfrProcessor {
    private static final String FEATURE = "camel-jfr";

    JfrProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    CamelServicePatternBuildItem excludeCamelJfrServicePattern() {
        return new CamelServicePatternBuildItem(CamelServiceDestination.DISCOVERY, false, new String[]{"META-INF/services/org/apache/camel/startup-step-recorder"});
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    RuntimeCamelContextCustomizerBuildItem customizeCamelContext(RuntimeCamelJfrConfig config, CamelJfrRecorder recorder) {
        return new RuntimeCamelContextCustomizerBuildItem(recorder.createStartupStepRecorder(config));
    }
}

