/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jfr.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import org.apache.camel.quarkus.component.jfr.CamelJfrConfig;
import org.apache.camel.quarkus.component.jfr.CamelJfrRecorder;
import org.apache.camel.quarkus.core.deployment.main.spi.CamelMainEnabled;
import org.apache.camel.quarkus.core.deployment.spi.CamelServiceDestination;
import org.apache.camel.quarkus.core.deployment.spi.CamelServicePatternBuildItem;
import org.apache.camel.quarkus.core.deployment.spi.CamelStartupStepRecorderBuildItem;

class JfrProcessor {
    private static final String FEATURE = "camel-jfr";

    JfrProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={CamelMainEnabled.class})
    CamelServicePatternBuildItem excludeCamelJfrServicePattern() {
        return new CamelServicePatternBuildItem(CamelServiceDestination.DISCOVERY, false, new String[]{"META-INF/services/org/apache/camel/startup-step-recorder"});
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    CamelStartupStepRecorderBuildItem customizeCamelContext(CamelJfrConfig config, CamelJfrRecorder recorder) {
        return new CamelStartupStepRecorderBuildItem(recorder.createStartupStepRecorder(config));
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void nativeUnsupported() {
        throw new RuntimeException("The camel-jfr extension is not supported in native mode as JFR APIs are not fully supported on GraalVM");
    }
}

