/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jcache.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

class JcacheProcessor {
    private static final Logger LOG = Logger.getLogger(JcacheProcessor.class);
    private static final String FEATURE = "camel-jcache";

    JcacheProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerCachingProvider(BuildProducer<ServiceProviderBuildItem> services) {
        Stream.of("javax.cache.spi.CachingProvider").forEach(service -> {
            try {
                Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + service));
                services.produce((BuildItem)new ServiceProviderBuildItem(service, (Collection)implementations));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

