/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.dsl.java.joor.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.Modifier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Recorder
public class JavaJoorDslRecorder {
    private static final Logger LOG = LoggerFactory.getLogger(JavaJoorDslRecorder.class);

    public void registerRoutesBuilder(RuntimeValue<CamelContext> context, String className, String location) throws Exception {
        Class<?> clazz = Class.forName(className);
        boolean skip = clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isPrivate(clazz.getModifiers());
        boolean ctr = ObjectHelper.hasDefaultNoArgConstructor(clazz);
        if (ctr && !skip) {
            try {
                Object obj = ((CamelContext)context.getValue()).getInjector().newInstance(clazz);
                if (obj instanceof RoutesBuilder) {
                    RoutesBuilder builder = (RoutesBuilder)obj;
                    CamelContextAware.trySetCamelContext((Object)obj, (CamelContext)((CamelContext)context.getValue()));
                    ResourceAware.trySetResource((Object)obj, (Resource)ResourceHelper.fromString((String)location, (String)""));
                    ((CamelContext)context.getValue()).addRoutes(builder);
                }
                LOG.warn("Ignoring the class {} as it is not of type RoutesBuilder", (Object)className);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot create instance of class: " + className, (Throwable)e);
            }
        } else {
            LOG.warn("Ignoring the class {} as it cannot be instantiated with the default constructor", (Object)className);
        }
    }
}

