/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ClasspathFileSource;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.recording.RecordingStatus;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.apache.camel.quarkus.test.wiremock.MockServer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public abstract class WireMockTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    protected static final Logger LOG = Logger.getLogger(WireMockTestResourceLifecycleManager.class);
    protected WireMockServer server;

    public Map<String, String> start() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.isMockingEnabled() || this.isRecordingEnabled()) {
            this.server = this.createServer();
            this.server.start();
            if (this.isRecordingEnabled()) {
                String recordTargetBaseUrl = this.getRecordTargetBaseUrl();
                if (recordTargetBaseUrl != null) {
                    LOG.infof("Enabling WireMock recording for %s", (Object)recordTargetBaseUrl);
                    this.server.startRecording(WireMock.recordSpec().forTarget(recordTargetBaseUrl).allowNonProxied(false));
                } else {
                    throw new IllegalStateException("Must return a non-null value from getRecordTargetBaseUrl() in order to support WireMock recording");
                }
            }
            String wireMockUrl = "http://localhost:" + this.server.port();
            LOG.infof("WireMock started on %s", (Object)wireMockUrl);
            properties.put("wiremock.url", wireMockUrl);
            if (this.server.getOptions().httpsSettings().enabled()) {
                properties.put("wiremock.url.ssl", "https://localhost:" + this.server.httpsPort());
            }
        }
        return properties;
    }

    public void stop() {
        if (this.server != null) {
            LOG.info((Object)"Stopping WireMockServer");
            if (this.server.getRecordingStatus().getStatus().equals((Object)RecordingStatus.Recording)) {
                LOG.info((Object)"Stopping recording");
                SnapshotRecordResult recordResult = this.server.stopRecording();
                List stubMappings = recordResult.getStubMappings();
                if (this.isDeleteRecordedMappingsOnError()) {
                    for (StubMapping mapping : stubMappings) {
                        int status = mapping.getResponse().getStatus();
                        if (status < 300 || !mapping.shouldBePersisted()) continue;
                        try {
                            String fileName = mapping.getName() + "-" + mapping.getId() + ".json";
                            Path mappingFilePath = Paths.get("./src/test/resources/mappings/", fileName);
                            Files.deleteIfExists(mappingFilePath);
                            LOG.infof("Deleted mapping file %s as status code was %d", (Object)fileName, (Object)status);
                        }
                        catch (IOException e) {
                            LOG.errorf("Failed to delete mapping file %s", (Object)e, (Object)mapping.getName());
                        }
                    }
                }
            }
            this.server.stop();
        }
    }

    public void inject(Object testInstance) {
        if (this.isMockingEnabled() || this.isRecordingEnabled()) {
            for (Class<?> testClass = testInstance.getClass(); testClass != Object.class; testClass = testClass.getSuperclass()) {
                for (Field field : testClass.getDeclaredFields()) {
                    if (field.getAnnotation(MockServer.class) == null) continue;
                    if (!WireMockServer.class.isAssignableFrom(field.getType())) {
                        throw new RuntimeException("@MockServer can only be used on fields of type WireMockServer");
                    }
                    field.setAccessible(true);
                    try {
                        if (this.server == null) {
                            LOG.info((Object)"Starting WireMockServer");
                            this.server = this.createServer();
                            this.server.start();
                        }
                        LOG.infof("Injecting WireMockServer for field %s", (Object)field.getName());
                        field.set(testInstance, this.server);
                        return;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    protected boolean envVarsPresent(String ... envVarNames) {
        if (envVarNames.length == 0) {
            throw new IllegalArgumentException("envVarNames must not be empty");
        }
        boolean present = true;
        for (String envVar : envVarNames) {
            if (System.getenv(envVar) != null) continue;
            present = false;
            break;
        }
        return present;
    }

    protected String envOrDefault(String envVarName, String defaultValue) {
        return ConfigProvider.getConfig().getOptionalValue(envVarName, String.class).orElse(defaultValue);
    }

    protected boolean isDeleteRecordedMappingsOnError() {
        return true;
    }

    protected abstract String getRecordTargetBaseUrl();

    protected abstract boolean isMockingEnabled();

    protected void customizeWiremockConfiguration(WireMockConfiguration config) {
    }

    private WireMockServer createServer() {
        LOG.info((Object)"Starting WireMockServer");
        MockBackendUtils.startMockBackend((boolean)true);
        WireMockConfiguration configuration = WireMockConfiguration.options().dynamicPort();
        this.customizeWiremockConfiguration(configuration);
        if (!this.isRecordingEnabled()) {
            configuration.fileSource((FileSource)new CamelQuarkusFileSource());
        }
        return new WireMockServer((Options)configuration);
    }

    private boolean isRecordingEnabled() {
        String recordEnabled = System.getProperty("wiremock.record", System.getenv("WIREMOCK_RECORD"));
        return recordEnabled != null && recordEnabled.equals("true");
    }

    private static class CamelQuarkusFileSource
    extends ClasspathFileSource {
        private CamelQuarkusFileSource() {
            super("");
        }

        public FileSource child(String subDirectoryName) {
            return new ClasspathFileSource(subDirectoryName);
        }
    }
}

