/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.xslt;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyExtensionFunction2
extends ExtensionFunctionDefinition {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MyExtensionFunction2.class);

    public StructuredQName getFunctionQName() {
        return new StructuredQName("", "http://mytest/", "myExtensionFunction2");
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 2;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        int resultCardinality = 1;
        return SequenceType.makeSequenceType((ItemType)SequenceType.SINGLE_STRING.getPrimaryType(), (int)resultCardinality);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){
            private static final long serialVersionUID = 1L;

            public Sequence call(XPathContext xPathContext, Sequence[] arguments) throws XPathException {
                StringValue arg1 = (StringValue)arguments[0].iterate().next();
                String arg1Str = arg1.getStringValue();
                String arg2Str = "";
                if (arguments.length > 1) {
                    StringValue arg2 = (StringValue)arguments[1].iterate().next();
                    arg2Str = arg2.getStringValue();
                }
                String resultStr = arg1Str + arg2Str;
                StringValue result = new StringValue(resultStr);
                return SequenceTool.toLazySequence((SequenceIterator)SingletonIterator.makeIterator((Item)result));
            }
        };
    }
}

