/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.kafka;

import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class KafkaTestSupport {
    public static String getBootstrapServers() {
        return KafkaTestSupport.getKafkaConfigValue("bootstrap.servers");
    }

    public static String getKafkaConfigValue(String key) {
        Config config = ConfigProvider.getConfig();
        Optional optional = config.getOptionalValue(key, String.class);
        if (!optional.isPresent()) {
            optional = config.getOptionalValue("kafka." + key, String.class);
        }
        if (!optional.isPresent() && key.equals("bootstrap.servers")) {
            optional = config.getOptionalValue("camel.component.kafka.brokers", String.class);
        }
        if (!optional.isPresent()) {
            throw new IllegalStateException("Property " + key + " has not been set");
        }
        return (String)optional.get();
    }

    public static void setKafkaConfigProperty(Properties props, String key) {
        props.put(key, KafkaTestSupport.getKafkaConfigValue(key));
    }

    public static void setKafkaConfigFromProperty(Properties props, String key, String valueKey) {
        props.put(key, KafkaTestSupport.getKafkaConfigValue(valueKey));
    }
}

