/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.kafka;

import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.apache.camel.quarkus.test.support.kafka.KafkaTestSupport;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaProducers {
    @ApplicationScoped
    @Named(value="kafka-consumer-properties")
    public Properties kafkaConsumerProperties() {
        Properties props = this.createBaseConfiguration();
        props.put("auto.offset.reset", "earliest");
        props.put("enable.auto.commit", "true");
        props.put("key.deserializer", IntegerDeserializer.class.getName());
        props.put("value.deserializer", StringDeserializer.class.getName());
        return props;
    }

    @ApplicationScoped
    @Named(value="kafka-producer-properties")
    public Properties kafkaProducerProperties() {
        Properties props = this.createBaseConfiguration();
        props.put("client.id", "camel-quarkus-kafka-client");
        props.put("key.serializer", IntegerSerializer.class.getName());
        props.put("value.serializer", StringSerializer.class.getName());
        return props;
    }

    private Properties createBaseConfiguration() {
        Properties props = new Properties();
        props.put("bootstrap.servers", KafkaTestSupport.getBootstrapServers());
        props.put("group.id", "camel-quarkus-group");
        return props;
    }
}

