/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.kafka;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.TestcontainersConfiguration;

public class KafkaTestResource
implements QuarkusTestResourceLifecycleManager {
    protected static final DockerImageName KAFKA_IMAGE_NAME = DockerImageName.parse((String)"confluentinc/cp-kafka").withTag("5.4.3");
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaTestResource.class);
    private KafkaContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = (KafkaContainer)((KafkaContainer)new KafkaContainer(KAFKA_IMAGE_NAME).withLogConsumer(frame -> System.out.print(frame.getUtf8String()))).withEmbeddedZookeeper().waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            return Collections.singletonMap("camel.component.kafka.brokers", this.container.getBootstrapServers());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.container != null) {
            try {
                this.container.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

