/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.azure;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.smallrye.config.SmallRyeConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class AzureStorageTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureStorageTestResource.class);
    private static final String AZURITE_IMAGE = (String)ConfigProvider.getConfig().getValue("azurite.container.image", String.class);
    private static final String EVENTHUBS_EMULATOR_IMAGE = (String)ConfigProvider.getConfig().getValue("eventhubs-emulator.container.image", String.class);
    private static final int EVENTHUBS_EMULATOR_PORT = 5672;
    private Map<String, String> initArgs = new LinkedHashMap<String, String>();
    private GenericContainer<?> container;
    private GenericContainer<?> eventHubsEmulatorContainer;
    private Network network = Network.newNetwork();

    public void init(Map<String, String> initArgs) {
        this.initArgs = initArgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> start() {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        String realAzureStorageAccountName = System.getenv("AZURE_STORAGE_ACCOUNT_NAME");
        boolean realCredentialsProvided = realAzureStorageAccountName != null && System.getenv("AZURE_STORAGE_ACCOUNT_KEY") != null;
        String azureBlobContainername = "camel-quarkus-" + String.valueOf(UUID.randomUUID());
        String azureStorageAccountName = (String)config.getValue("azure.storage.account-name", String.class);
        boolean startMockBackend = MockBackendUtils.startMockBackend((boolean)false);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (startMockBackend && !realCredentialsProvided) {
            MockBackendUtils.logMockBackendUsed();
            try {
                this.container = new GenericContainer(AZURITE_IMAGE).withNetworkAliases(new String[]{"azurite"}).withNetwork(this.network).withExposedPorts(AzuriteService.getAzuritePorts()).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forListeningPort());
                this.container.start();
                result.put("azure.blob.container.name", azureBlobContainername);
                Stream.of(AzuriteService.values()).forEach(s -> result.put("azure." + s.name() + ".service.url", "http://" + this.container.getHost() + ":" + (s.azuritePort >= 0 ? this.container.getMappedPort(s.azuritePort) : s.azuritePort) + "/" + azureStorageAccountName));
                String eventHubs = this.initArgs.get("eventHubs");
                if (eventHubs == null || !eventHubs.equals("true")) return result;
                result.put("azure.event.hubs.blob.container.name", azureBlobContainername);
                this.eventHubsEmulatorContainer = new GenericContainer(EVENTHUBS_EMULATOR_IMAGE).withNetwork(this.network).withCreateContainerCmdModifier(createContainerCmd -> {
                    Ports portBindings = new Ports();
                    portBindings.bind(ExposedPort.tcp((int)5672), Ports.Binding.bindPort((int)5672));
                    HostConfig hostConfig = HostConfig.newHostConfig().withPortBindings(portBindings).withNetworkMode(this.network.getId());
                    createContainerCmd.withHostName("eventhubs-emulator").withHostConfig(hostConfig);
                }).withExposedPorts(new Integer[]{5672}).withEnv("BLOB_SERVER", "azurite").withEnv("METADATA_SERVER", "azurite").withEnv("ACCEPT_EULA", "Y").withCopyFileToContainer(MountableFile.forClasspathResource((String)"config.json"), "/Eventhubs_Emulator/ConfigFiles/Config.json").withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Emulator Service is Successfully Up.*", (int)1));
                this.eventHubsEmulatorContainer.start();
                String connectionString = "Endpoint=sb://%s;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=SAS_KEY_VALUE;UseDevelopmentEmulator=true;EntityPath=eh1".formatted(this.container.getHost());
                result.put("azure.event.hubs.connection.string", connectionString);
                return result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!startMockBackend && !realCredentialsProvided) {
                throw new IllegalStateException("Set AZURE_STORAGE_ACCOUNT_NAME and AZURE_STORAGE_ACCOUNT_KEY env vars if you set CAMEL_QUARKUS_START_MOCK_BACKEND=false");
            }
            MockBackendUtils.logRealBackendUsed();
            result.put("azure.blob.container.name", azureBlobContainername);
            Stream.of(AzuriteService.values()).forEach(s -> result.put("azure." + s.name() + ".service.url", "https://" + realAzureStorageAccountName + "." + s.getAzureServiceCode() + ".core.windows.net"));
        }
        return result;
    }

    public void stop() {
        try {
            if (this.eventHubsEmulatorContainer != null) {
                this.eventHubsEmulatorContainer.stop();
            }
            if (this.container != null) {
                this.container.stop();
            }
            if (this.network != null) {
                this.network.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum AzuriteService {
        blob(10000),
        queue(10001);

        private final int azuritePort;
        private final String azureServiceCode;

        private AzuriteService(int port) {
            this(port, null);
        }

        private AzuriteService(int port, String azureServiceCode) {
            this.azuritePort = port;
            this.azureServiceCode = azureServiceCode;
        }

        public static Integer[] getAzuritePorts() {
            return (Integer[])Stream.of(AzuriteService.values()).mapToInt(AzuriteService::getAzuritePort).filter(p -> p >= 0).boxed().toArray(Integer[]::new);
        }

        public int getAzuritePort() {
            return this.azuritePort;
        }

        public String getAzureServiceCode() {
            return this.azureServiceCode == null ? this.name() : this.azureServiceCode;
        }
    }
}

