/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.azure;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class AzureServiceBusTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureServiceBusTestResource.class);
    private static final String SQL_IMAGE = (String)ConfigProvider.getConfig().getValue("sql-server.container.image", String.class);
    private static final String EMULATOR_IMAGE = (String)ConfigProvider.getConfig().getValue("servicebus-emulator.container.image", String.class);
    private static final int SERVICEBUS_INNER_PORT = 5672;
    private static final String MSSQL_PASSWORD = "12345678923456y!43";
    private GenericContainer<?> emulatorContainer;
    private GenericContainer<?> sqlContainer;

    public Map<String, String> start() {
        boolean realCredentialsProvided = System.getenv("AZURE_SERVICEBUS_CONNECTION_STRING") != null && System.getenv("AZURE_SERVICEBUS_QUEUE_NAME") != null;
        boolean startMockBackend = MockBackendUtils.startMockBackend((boolean)false);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (startMockBackend && !realCredentialsProvided) {
            MockBackendUtils.logMockBackendUsed();
            try {
                Network azureNetwork = Network.newNetwork();
                this.sqlContainer = new GenericContainer(SQL_IMAGE).withEnv(Collections.singletonMap("MSSQL_AGENT_ENABLED", "True")).withNetwork(azureNetwork).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withEnv("ACCEPT_EULA", "Y").withEnv("MSSQL_SA_PASSWORD", MSSQL_PASSWORD).withNetworkAliases(new String[]{"sql-edge"}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*xp_sqlagent_notify.*", (int)1));
                this.sqlContainer.start();
                this.emulatorContainer = new GenericContainer(EMULATOR_IMAGE).withNetwork(azureNetwork).withExposedPorts(new Integer[]{5672}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).withEnv("ACCEPT_EULA", "Y").withEnv("MSSQL_SA_PASSWORD", MSSQL_PASSWORD).withEnv("SQL_SERVER", "sql-edge").withCopyFileToContainer(MountableFile.forClasspathResource((String)"servicebus-config.json"), "/ServiceBus_Emulator/ConfigFiles/Config.json").waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Emulator Service is Successfully Up!.*", (int)1));
                this.emulatorContainer.start();
                String connectionString = "Endpoint=sb://%s:%d;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=SAS_KEY_VALUE;UseDevelopmentEmulator=true;".formatted("localhost", this.emulatorContainer.getMappedPort(5672));
                result.put("azure.servicebus.connection.string", connectionString);
                result.put("azure.servicebus.queue.name", "queue.1");
                result.put("azure.servicebus.topic.name", "topic.1");
                result.put("azure.servicebus.topic.subscription.name", "subscription.1");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (!startMockBackend && !realCredentialsProvided) {
            throw new IllegalStateException("Set AZURE_SERVICEBUS_CONNECTION_STRING and AZURE_SERVICEBUS_QUEUE_NAME env vars if you set CAMEL_QUARKUS_START_MOCK_BACKEND=false");
        }
        return result;
    }

    public void stop() {
        try {
            if (this.emulatorContainer != null) {
                this.emulatorContainer.stop();
            }
            if (this.sqlContainer != null) {
                this.sqlContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

