/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.azure;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.smallrye.config.SmallRyeConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class AzureStorageTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureStorageTestResource.class);
    private static final String AZURITE_IMAGE = "mcr.microsoft.com/azure-storage/azurite:3.14.2";
    private GenericContainer<?> container;

    public Map<String, String> start() {
        SmallRyeConfig config = ConfigUtils.configBuilder((boolean)true, (LaunchMode)LaunchMode.NORMAL).build();
        String realAzureStorageAccountName = System.getenv("AZURE_STORAGE_ACCOUNT_NAME");
        boolean realCredentialsProvided = realAzureStorageAccountName != null && System.getenv("AZURE_STORAGE_ACCOUNT_KEY") != null;
        String azureBlobContainername = "camel-quarkus-" + UUID.randomUUID().toString();
        String azureStorageAccountName = (String)config.getValue("azure.storage.account-name", String.class);
        boolean startMockBackend = MockBackendUtils.startMockBackend((boolean)false);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (startMockBackend && !realCredentialsProvided) {
            MockBackendUtils.logMockBackendUsed();
            try {
                this.container = new GenericContainer(AZURITE_IMAGE).withExposedPorts(Service.getAzuritePorts()).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forListeningPort());
                this.container.start();
                result.put("azure.blob.container.name", azureBlobContainername);
                Stream.of(Service.values()).forEach(s -> result.put("azure." + s.name() + ".service.url", "http://" + this.container.getContainerIpAddress() + ":" + (s.azuritePort >= 0 ? this.container.getMappedPort(s.azuritePort) : s.azuritePort) + "/" + azureStorageAccountName));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!startMockBackend && !realCredentialsProvided) {
                throw new IllegalStateException("Set AZURE_STORAGE_ACCOUNT_NAME and AZURE_STORAGE_ACCOUNT_KEY env vars if you set CAMEL_QUARKUS_START_MOCK_BACKEND=false");
            }
            MockBackendUtils.logRealBackendUsed();
            result.put("azure.blob.container.name", azureBlobContainername);
            Stream.of(Service.values()).forEach(s -> result.put("azure." + s.name() + ".service.url", "https://" + realAzureStorageAccountName + "." + s.getAzureServiceCode() + ".core.windows.net"));
        }
        return result;
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum Service {
        blob(10000),
        queue(10001),
        datalake(-1, "dfs");

        private final int azuritePort;
        private final String azureServiceCode;

        private Service(int port) {
            this(port, null);
        }

        private Service(int port, String azureServiceCode) {
            this.azuritePort = port;
            this.azureServiceCode = azureServiceCode;
        }

        public static Integer[] getAzuritePorts() {
            return (Integer[])Stream.of(Service.values()).mapToInt(Service::getAzuritePort).filter(p -> p >= 0).mapToObj(p -> p).toArray(Integer[]::new);
        }

        public int getAzuritePort() {
            return this.azuritePort;
        }

        public String getAzureServiceCode() {
            return this.azureServiceCode == null ? this.name() : this.azureServiceCode;
        }
    }
}

