/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.aws2;

import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkClientException;

public class Aws2Helper {
    public static final String UNABLE_TO_LOAD_CREDENTIALS_MSG = "Unable to load credentials";

    public static boolean isDefaultCredentialsProviderDefinedOnSystem() {
        block2: {
            try {
                DefaultCredentialsProvider.create().resolveCredentials();
            }
            catch (Exception e) {
                if (!(e instanceof SdkClientException) || e.getMessage() == null || !e.getMessage().startsWith(UNABLE_TO_LOAD_CREDENTIALS_MSG)) break block2;
                return false;
            }
        }
        return true;
    }

    public static void setAwsSystemCredentials(String accessKey, String secretKey) {
        System.setProperty("aws.accessKeyId", accessKey);
        System.setProperty("aws.secretAccessKey", secretKey);
    }

    public static void clearAwsSystemCredentials() {
        System.clearProperty("aws.accessKeyId");
        System.clearProperty("aws.secretAccessKey");
    }
}

