/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.aws2;

import java.util.stream.StreamSupport;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.apache.camel.quarkus.test.support.aws2.Aws2Helper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Aws2DefaultCredentialsProviderAvailabilityCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (!MockBackendUtils.startMockBackend((boolean)false)) {
            return ConditionEvaluationResult.disabled((String)"Test can be executed only with mock backend.");
        }
        if (StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false).anyMatch(n -> n.matches("quarkus.(dynamodb|s3|ses|sqs|sns).sync-client.type"))) {
            return ConditionEvaluationResult.disabled((String)"Test can not be executed quarkus aws client configuration detected.");
        }
        if (Aws2Helper.isDefaultCredentialsProviderDefinedOnSystem()) {
            return ConditionEvaluationResult.disabled((String)"DefaultCredentialsProvider is already defined in the system.");
        }
        return ConditionEvaluationResult.enabled((String)"DefaultCredentialsProvider is NOT defined in the system, Testing can proceed.");
    }
}

