/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.aws2;

import io.quarkus.runtime.ShutdownEvent;
import jakarta.enterprise.event.Observes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.camel.quarkus.test.support.aws2.Aws2Helper;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class BaseAws2Resource {
    private static final Logger LOG = Logger.getLogger(BaseAws2Resource.class);
    private boolean useDefaultCredentials;
    private final String serviceName;
    private boolean clearAwsredentials;

    public BaseAws2Resource(String serviceName) {
        this.serviceName = serviceName;
    }

    @Path(value="/setUseDefaultCredentialsProvider")
    @POST
    public Response setUseDefaultCredentials(boolean useDefaultCredentialsProvider) throws Exception {
        this.useDefaultCredentials = useDefaultCredentialsProvider;
        return Response.ok().build();
    }

    @Path(value="/initializeDefaultCredentials")
    @POST
    @Produces(value={"text/plain"})
    public Response initializeDefaultCredentials(boolean initialize) throws Exception {
        if (initialize) {
            this.clearAwsredentials = true;
            LOG.debug((Object)"Setting both System.properties `aws.secretAccessKey` and `aws.accessKeyId` to cover defaultCredentialsProviderTest.");
            Aws2Helper.setAwsSystemCredentials((String)ConfigProvider.getConfig().getValue("camel.component.aws2-" + this.serviceName + ".access-key", String.class), (String)ConfigProvider.getConfig().getValue("camel.component.aws2-" + this.serviceName + ".secret-key", String.class));
        } else {
            LOG.debug((Object)"Clearing both System.properties `aws.secretAccessKey` and `aws.accessKeyId`.");
            Aws2Helper.clearAwsSystemCredentials();
            this.clearAwsredentials = false;
        }
        return Response.ok().build();
    }

    void onStop(@Observes ShutdownEvent ev) {
        if (this.clearAwsredentials) {
            Aws2Helper.clearAwsSystemCredentials();
        }
    }

    public boolean isUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }
}

