/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.aws2;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.regions.Region;

public class Aws2TestEnvContext {
    private static final Logger LOG = Logger.getLogger(Aws2TestEnvContext.class);
    private final ArrayList<AutoCloseable> closeables = new ArrayList();
    private final Map<LocalStackContainer.Service, ? extends SdkClient> clients = new EnumMap<LocalStackContainer.Service, SdkClient>(LocalStackContainer.Service.class);
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private final String accessKey;
    private final String secretKey;
    private final String region;
    private final Optional<LocalStackContainer> localstack;

    public Aws2TestEnvContext(String accessKey, String secretKey, String region, Optional<LocalStackContainer> localstack, LocalStackContainer.Service[] exportCredentialsServices) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
        this.localstack = localstack;
        localstack.ifPresent(ls -> {
            for (LocalStackContainer.Service service : exportCredentialsServices) {
                String s = Aws2TestEnvContext.camelServiceAcronym(service);
                if (s == null) continue;
                this.properties.put("camel.component.aws2-" + s + ".access-key", accessKey);
                this.properties.put("camel.component.aws2-" + s + ".secret-key", secretKey);
                this.properties.put("camel.component.aws2-" + s + ".region", region);
                this.properties.put("camel.component.aws2-" + s + ".override-endpoint", "true");
                this.properties.put("camel.component.aws2-" + s + ".uri-endpoint-override", ls.getEndpointOverride(service).toString());
            }
        });
    }

    public Aws2TestEnvContext property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public Aws2TestEnvContext closeable(AutoCloseable closeable) {
        this.closeables.add(closeable);
        return this;
    }

    public Map<String, String> getProperies() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void close() {
        ListIterator<AutoCloseable> it = this.closeables.listIterator(this.closeables.size());
        while (it.hasPrevious()) {
            AutoCloseable c = it.previous();
            if (c instanceof SdkClient) {
                this.clients.entrySet().stream().filter(en -> c == en.getValue()).map(Map.Entry::getKey).findFirst().map(this.clients::remove);
            }
            try {
                c.close();
            }
            catch (Exception e) {
                LOG.warnf((Throwable)e, "Could not close %s", (Object)c);
            }
        }
        if (this.localstack.isPresent()) {
            this.localstack.get().stop();
        }
    }

    public <B extends AwsClientBuilder<B, C>, C extends SdkClient> C client(LocalStackContainer.Service service, Supplier<B> builderSupplier) {
        AwsClientBuilder builder = ((AwsClientBuilder)builderSupplier.get()).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey)));
        builder.region(Region.of((String)this.region));
        if (this.localstack.isPresent()) {
            ((AwsClientBuilder)builder.endpointOverride(this.localstack.get().getEndpointOverride(service))).region(Region.of((String)this.region));
        } else if (service == LocalStackContainer.Service.IAM) {
            builder.endpointOverride(URI.create("https://iam.amazonaws.com"));
            builder.region(Region.of((String)"us-east-1"));
        }
        SdkClient client = (SdkClient)builder.build();
        this.closeables.add((AutoCloseable)client);
        return (C)client;
    }

    SdkClient client(LocalStackContainer.Service service, Class<?> clientType) {
        SdkClient result = this.clients.get(service);
        if (result != null) {
            return result;
        }
        return this.client(service, () -> {
            try {
                return (AwsClientBuilder)clientType.getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Could not call " + clientType.getName() + ".builder()", e);
            }
        });
    }

    private static String camelServiceAcronym(LocalStackContainer.Service service) {
        switch (service) {
            case DYNAMODB: {
                return "ddb";
            }
            case DYNAMODB_STREAMS: {
                return "ddbstream";
            }
            case FIREHOSE: {
                return "kinesis-firehose";
            }
            case CLOUDWATCH: {
                return "cw";
            }
        }
        return service.name().toLowerCase(Locale.ROOT);
    }

    public String getRegion() {
        return this.region;
    }
}

