/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.test.support.aws2;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.apache.camel.quarkus.test.support.aws2.Aws2Client;
import org.apache.camel.quarkus.test.support.aws2.Aws2LocalStack;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.core.SdkClient;

public final class Aws2TestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(Aws2TestResource.class);
    private Aws2TestEnvContext envContext;

    public Map<String, String> start() {
        String realKey = System.getenv("AWS_ACCESS_KEY");
        String realSecret = System.getenv("AWS_SECRET_KEY");
        String realRegion = System.getenv("AWS_REGION");
        boolean realCredentialsProvided = realKey != null && realSecret != null && realRegion != null;
        boolean startMockBackend = MockBackendUtils.startMockBackend((boolean)false);
        boolean usingMockBackend = startMockBackend && !realCredentialsProvided;
        ServiceLoader<Aws2TestEnvCustomizer> loader = ServiceLoader.load(Aws2TestEnvCustomizer.class);
        ArrayList<Aws2TestEnvCustomizer> customizers = new ArrayList<Aws2TestEnvCustomizer>();
        for (Aws2TestEnvCustomizer customizer2 : loader) {
            LOG.info("Loaded Aws2TestEnvCustomizer " + customizer2.getClass().getName());
            customizers.add(customizer2);
        }
        LOG.info("Loaded " + customizers.size() + " Aws2TestEnvCustomizers");
        if (usingMockBackend) {
            MockBackendUtils.logMockBackendUsed();
            LocalStackContainer.Service[] services = (LocalStackContainer.Service[])customizers.stream().map(Aws2TestEnvCustomizer::localstackServices).flatMap(ss -> Stream.of(ss)).distinct().toArray(LocalStackContainer.Service[]::new);
            LocalStackContainer.Service[] exportCredentialsServices = (LocalStackContainer.Service[])customizers.stream().map(Aws2TestEnvCustomizer::exportCredentialsForLocalstackServices).flatMap(ss -> Stream.of(ss)).distinct().toArray(LocalStackContainer.Service[]::new);
            LocalStackContainer localstack = new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:0.12.17.5")).withServices(services);
            localstack.withEnv("LAMBDA_EXECUTOR", "local");
            localstack.withLogConsumer((Consumer)new Slf4jLogConsumer(LOG));
            localstack.start();
            this.envContext = new Aws2TestEnvContext(localstack.getAccessKey(), localstack.getSecretKey(), localstack.getRegion(), Optional.of(localstack), exportCredentialsServices);
        } else {
            if (!startMockBackend && !realCredentialsProvided) {
                throw new IllegalStateException("Set AWS_ACCESS_KEY, AWS_SECRET_KEY and AWS_REGION env vars if you set CAMEL_QUARKUS_START_MOCK_BACKEND=false");
            }
            MockBackendUtils.logRealBackendUsed();
            this.envContext = new Aws2TestEnvContext(realKey, realSecret, realRegion, Optional.empty(), new LocalStackContainer.Service[0]);
        }
        customizers.forEach(customizer -> customizer.customize(this.envContext));
        return this.envContext.getProperies();
    }

    public void stop() {
        this.envContext.close();
    }

    public void inject(Object testInstance) {
        for (Class<?> c = testInstance.getClass(); c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                Aws2LocalStack localStackAnnot;
                Aws2Client clientAnnot = f.getAnnotation(Aws2Client.class);
                if (clientAnnot != null) {
                    LocalStackContainer.Service service = clientAnnot.value();
                    f.setAccessible(true);
                    SdkClient client = this.envContext.client(service, f.getType());
                    try {
                        f.set(testInstance, client);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException("Could not set " + c.getName() + "." + f.getName(), e);
                    }
                }
                if ((localStackAnnot = f.getAnnotation(Aws2LocalStack.class)) == null) continue;
                f.setAccessible(true);
                try {
                    f.set(testInstance, this.envContext.isLocalStack());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException("Could not set " + c.getName() + "." + f.getName(), e);
                }
            }
        }
    }
}

