/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.jdbc.oracle;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

@ApplicationScoped
public class OracleJdbcRoutes
extends RouteBuilder {
    private String dbKind = "oracle";

    public void configure() {
        ((RouteDefinition)this.from("direct://get-generated-keys-" + this.dbKind).to("jdbc:" + this.dbKind)).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                System.out.println(exchange.getIn().getHeaders());
                Object in = exchange.getIn().getHeader("CamelGeneratedKeysRows");
                exchange.getIn().setBody(in);
            }
        });
        ((RouteDefinition)this.from("direct://get-headers-" + this.dbKind).to("jdbc:" + this.dbKind)).process(new Processor(){

            public void process(Exchange exchange) throws Exception {
                Map in = exchange.getIn().getHeaders();
                exchange.getIn().setBody((Object)in);
            }
        });
        this.from("direct://headers-as-parameters-" + this.dbKind).to("jdbc:" + this.dbKind + "?useHeadersAsParameters=true");
        ((RouteDefinition)((RouteDefinition)this.from("timer://interval-polling-" + this.dbKind + "?delay=2000&repeatCount=1").routeId("jdbc-poll-" + this.dbKind).autoStartup(false).setBody((Expression)this.constant("select * from camelsGenerated order by id desc"))).to("jdbc:" + this.dbKind)).to("mock:interval-polling-" + this.dbKind);
        String species = "SPECIES";
        ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct://move-between-datasources-" + this.dbKind).setBody((Expression)this.constant("select * from camels"))).to("jdbc:" + this.dbKind)).split((Expression)this.body()).setBody((Expression)this.simple("insert into camelsProcessed (species) values('${body[" + species + "]}')"))).to("jdbc:" + this.dbKind);
    }
}

